/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.handlers.BaseSearchContext;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

public class SearchHandler
implements Processor,
ResourceUtilizer,
Session.ResourceKey<Context> {
    private final byte[] begin;
    private final byte[] end;
    private final int beginHash;
    private final int endHash;
    private final int beginCoef;
    private final int endCoef;
    private Processor processor;

    public SearchHandler(String begin, String end, Processor processor) {
        this.begin = begin.getBytes(StandardCharsets.UTF_8);
        this.end = end.getBytes(StandardCharsets.UTF_8);
        this.beginHash = BaseSearchContext.computeHash(this.begin);
        this.beginCoef = BaseSearchContext.computeCoef(this.begin.length);
        this.endHash = BaseSearchContext.computeHash(this.end);
        this.endCoef = BaseSearchContext.computeCoef(this.end.length);
        this.processor = processor;
    }

    public void before(Session session) {
        Context ctx = (Context)session.getResource((Session.ResourceKey)this);
        ctx.reset();
        this.processor.before(session);
    }

    public void process(Session session, ByteBuf data, int offset, int length, boolean isLast) {
        Context ctx = (Context)session.getResource((Session.ResourceKey)this);
        ctx.add(data, offset, length);
        int endIndex = offset + length;
        int index = ctx.initHash(offset, ctx.lookupText.length);
        while (ctx.test(index)) {
            if (ctx.lookupText == this.end) {
                this.fireProcessor(ctx, session, index);
            } else {
                ctx.mark(index);
            }
            ctx.swap();
            index = ctx.initHash(index, ctx.lookupText.length);
        }
        while (index < endIndex) {
            ctx.advance(data.getByte(index++), ctx.lookupCoef, index, ctx.lookupText.length + 1);
            while (ctx.test(index)) {
                if (ctx.lookupText == this.end) {
                    this.fireProcessor(ctx, session, index);
                } else {
                    ctx.mark(index);
                }
                ctx.swap();
                index = ctx.initHash(index, ctx.lookupText.length);
            }
        }
    }

    private void fireProcessor(Context ctx, Session session, int index) {
        int endPart = ctx.currentPart;
        int endPos = index - this.end.length;
        while (endPos < 0) {
            if (--endPart < 0) {
                endPart = 0;
                endPos = 0;
                continue;
            }
            endPos += ctx.endIndices[endPart];
        }
        while (ctx.markPart < endPart) {
            ByteBuf data = ctx.parts[ctx.markPart];
            int length = ctx.endIndices[ctx.markPart] - ctx.markPos;
            if (length > 0) {
                this.processor.process(session, data, ctx.markPos, length, false);
            }
            ctx.markPos = 0;
            ++ctx.markPart;
        }
        this.processor.process(session, ctx.parts[endPart], ctx.markPos, endPos - ctx.markPos, true);
    }

    public void after(Session session) {
        Context ctx = (Context)session.getResource((Session.ResourceKey)this);
        ctx.reset();
        this.processor.after(session);
    }

    public void reserve(Session session) {
        session.declareResource((Session.ResourceKey)this, () -> new Context());
    }

    class Context
    extends BaseSearchContext {
        byte[] lookupText;
        int lookupHash;
        int lookupCoef;
        int markPart = -1;
        int markPos = -1;

        Context() {
        }

        void swap() {
            this.currentHash = 0;
            this.hashedBytes = 0;
            if (this.lookupText == SearchHandler.this.end) {
                this.lookupText = SearchHandler.this.begin;
                this.lookupHash = SearchHandler.this.beginHash;
                this.lookupCoef = SearchHandler.this.beginCoef;
            } else {
                this.lookupText = SearchHandler.this.end;
                this.lookupHash = SearchHandler.this.endHash;
                this.lookupCoef = SearchHandler.this.endCoef;
            }
        }

        boolean test(int index) {
            if (this.currentHash == this.lookupHash) {
                for (int i = 0; i < this.lookupText.length; ++i) {
                    if (this.lookupText[i] == this.byteRelative(index, this.lookupText.length - i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        void shiftParts() {
            super.shiftParts();
            --this.markPart;
            if (this.markPart < 0) {
                this.markPart = 0;
                this.markPos = 0;
            }
        }

        @Override
        void reset() {
            super.reset();
            this.lookupText = SearchHandler.this.begin;
            this.lookupHash = SearchHandler.this.beginHash;
            this.lookupCoef = SearchHandler.this.beginCoef;
            this.markPart = -1;
            this.markPos = -1;
        }

        void mark(int index) {
            this.markPart = this.currentPart;
            this.markPos = index;
        }
    }
}

