/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.handlers.BaseSearchContext;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.function.IntPredicate;

public class SearchValidator
implements Processor,
ResourceUtilizer,
Session.ResourceKey<Context> {
    private final byte[] text;
    private final int hash;
    private final int coef;
    private final IntPredicate match;

    public SearchValidator(String text, IntPredicate match) {
        this.text = text.getBytes(StandardCharsets.UTF_8);
        this.match = match;
        this.hash = BaseSearchContext.computeHash(this.text);
        this.coef = BaseSearchContext.computeCoef(this.text.length);
    }

    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        Context ctx = (Context)session.getResource((Session.ResourceKey)this);
        ctx.add(data, offset, length);
        int endIndex = offset + length;
        int index = ctx.initHash(offset, this.text.length);
        index = this.test(ctx, index);
        while (index < endIndex) {
            ctx.advance(data.getByte(index++), this.coef, index, this.text.length + 1);
            index = this.test(ctx, index);
        }
    }

    private int test(Context ctx, int index) {
        if (ctx.currentHash == this.hash) {
            for (int i = 0; i < this.text.length; ++i) {
                if (this.text[i] == ctx.byteRelative(index, this.text.length - i)) continue;
                return i;
            }
            ++ctx.matches;
            ctx.currentHash = 0;
            ctx.hashedBytes = 0;
            return ctx.initHash(index, this.text.length);
        }
        return index;
    }

    public void before(Session session) {
        Context ctx = (Context)session.getResource((Session.ResourceKey)this);
        ctx.reset();
    }

    public void after(Session session) {
        Context ctx = (Context)session.getResource((Session.ResourceKey)this);
        boolean match = this.match.test(ctx.matches);
        ctx.reset();
        if (!match) {
            session.currentRequest().markInvalid();
        }
    }

    public void reserve(Session session) {
        session.declareResource((Session.ResourceKey)this, Context::new);
    }

    static class Context
    extends BaseSearchContext {
        int matches;

        Context() {
        }

        @Override
        public void reset() {
            super.reset();
            this.matches = 0;
        }
    }
}

