/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.IntAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.handlers.DefragProcessor;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.impl.Util;
import io.netty.buffer.ByteBuf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoreIntProcessor
implements Processor {
    private static final Logger log = LogManager.getLogger(StoreIntProcessor.class);
    private final IntAccess toVar;
    private final boolean override;

    public StoreIntProcessor(IntAccess toVar, boolean override) {
        this.toVar = toVar;
        this.override = override;
    }

    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        this.ensureDefragmented(isLastPart);
        if (this.toVar.isSet(session) && !this.override) {
            log.warn("#{} Variable {} was already set, not setting again.", (Object)session.uniqueId(), (Object)this.toVar);
        } else {
            try {
                long value = Util.parseLong((ByteBuf)data, (int)offset, (int)length);
                this.toVar.setInt(session, (int)value);
            }
            catch (NumberFormatException e) {
                log.warn("#{} Not storing anything because it cannot be parsed to integer: {}", (Object)session.uniqueId(), (Object)Util.toString((ByteBuf)data, (int)offset, (int)length));
            }
        }
    }

    @Name(value="storeInt")
    public static class Builder
    implements Processor.Builder,
    InitFromParam<Builder> {
        private String toVar;
        private boolean override;

        public Builder init(String param) {
            return this.toVar(param);
        }

        public Builder toVar(String toVar) {
            this.toVar = toVar;
            return this;
        }

        public Builder override(boolean override) {
            this.override = override;
            return this;
        }

        public Processor build(boolean fragmented) {
            return DefragProcessor.of(new StoreIntProcessor(SessionFactory.intAccess(this.toVar), this.override), fragmented);
        }
    }
}

