/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.data.DataFormat;
import io.hyperfoil.core.handlers.DefragProcessor;
import io.hyperfoil.core.session.SessionFactory;
import io.netty.buffer.ByteBuf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoreProcessor
implements Processor {
    private static final Logger log = LogManager.getLogger(StoreProcessor.class);
    private final ObjectAccess toVar;
    private final DataFormat format;

    public StoreProcessor(ObjectAccess toVar, DataFormat format) {
        this.toVar = toVar;
        this.format = format;
    }

    public void before(Session session) {
        this.toVar.unset(session);
    }

    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        this.ensureDefragmented(isLastPart);
        if (this.toVar.isSet(session)) {
            log.warn("Variable {} was already set, not setting again.", (Object)this.toVar);
        } else {
            Object value = this.format.convert(data, offset, length);
            this.toVar.setObject(session, value);
        }
    }

    @Name(value="simple")
    @Deprecated
    public static class LegacyBuilder
    extends Builder {
    }

    @Name(value="store")
    public static class Builder
    implements Processor.Builder,
    InitFromParam<Builder> {
        private Object toVar;
        private DataFormat format = DataFormat.STRING;

        public Builder init(String param) {
            this.toVar = param;
            return this;
        }

        public Builder toVar(Object toVar) {
            this.toVar = toVar;
            return this;
        }

        public Builder format(DataFormat format) {
            this.format = format;
            return this;
        }

        public Processor build(boolean fragmented) {
            StoreProcessor storeProcessor = new StoreProcessor(SessionFactory.objectAccess(this.toVar), this.format);
            return fragmented ? new DefragProcessor(storeProcessor) : storeProcessor;
        }
    }
}

