/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers.json;

import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.processor.Transformer;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;

public class JsonUnquotingTransformer
implements Transformer,
Processor,
ResourceUtilizer,
Session.ResourceKey<Context> {
    private static final ByteBuf NEWLINE = Unpooled.wrappedBuffer((byte[])"\n".getBytes(StandardCharsets.UTF_8));
    private static final ByteBuf BACKSPACE = Unpooled.wrappedBuffer((byte[])"\b".getBytes(StandardCharsets.UTF_8));
    private static final ByteBuf FORMFEED = Unpooled.wrappedBuffer((byte[])"\f".getBytes(StandardCharsets.UTF_8));
    private static final ByteBuf CR = Unpooled.wrappedBuffer((byte[])"\r".getBytes(StandardCharsets.UTF_8));
    private static final ByteBuf TAB = Unpooled.wrappedBuffer((byte[])"\t".getBytes(StandardCharsets.UTF_8));
    protected final Transformer delegate;

    public JsonUnquotingTransformer(Transformer delegate) {
        this.delegate = delegate;
    }

    public JsonUnquotingTransformer(Processor delegate) {
        this((Transformer)new Transformer.ProcessorAdapter(delegate));
    }

    public void before(Session session) {
        this.delegate.before(session);
        Context context = (Context)session.getResource((Session.ResourceKey)this);
        context.reset();
    }

    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        this.transform(session, data, offset, length, isLastPart, null);
    }

    public void transform(Session session, ByteBuf input, int offset, int length, boolean isLastFragment, ByteBuf output) {
        Context context = (Context)session.getResource((Session.ResourceKey)this);
        int begin = context.unicode ? offset + this.processUnicode(session, input, offset, length, isLastFragment, output, context, 0) : (context.first && input.getByte(offset) == 34 ? offset + 1 : offset);
        for (int i = begin - offset; i < length; ++i) {
            if (context.escaped || input.getByte(offset + i) == 92) {
                int fragmentLength = offset + i - begin;
                if (fragmentLength > 0) {
                    this.delegate.transform(session, input, begin, fragmentLength, isLastFragment && fragmentLength == length, output);
                }
                if (context.escaped) {
                    context.escaped = false;
                } else if (++i >= length) {
                    context.escaped = true;
                    begin = offset + i;
                    break;
                }
                switch (input.getByte(offset + i)) {
                    case 110: {
                        this.delegate.transform(session, NEWLINE, 0, NEWLINE.readableBytes(), isLastFragment && i == length - 1, output);
                        begin = offset + i + 1;
                        break;
                    }
                    case 98: {
                        this.delegate.transform(session, BACKSPACE, 0, BACKSPACE.readableBytes(), isLastFragment && i == length - 1, output);
                        begin = offset + i + 1;
                        break;
                    }
                    case 102: {
                        this.delegate.transform(session, FORMFEED, 0, FORMFEED.readableBytes(), isLastFragment && i == length - 1, output);
                        begin = offset + i + 1;
                        break;
                    }
                    case 114: {
                        this.delegate.transform(session, CR, 0, CR.readableBytes(), isLastFragment && i == length - 1, output);
                        begin = offset + i + 1;
                        break;
                    }
                    case 116: {
                        this.delegate.transform(session, TAB, 0, TAB.readableBytes(), isLastFragment && i == length - 1, output);
                        begin = offset + i + 1;
                        break;
                    }
                    case 117: {
                        context.unicode = true;
                        ++i;
                        i = this.processUnicode(session, input, offset, length, isLastFragment, output, context, i) - 1;
                        begin = offset + i + 1;
                        break;
                    }
                    default: {
                        assert (false);
                    }
                    case 34: 
                    case 47: 
                    case 92: {
                        begin = offset + i;
                        break;
                    }
                }
                continue;
            }
            if (!isLastFragment || i != length - 1 || input.getByte(offset + i) != 34) continue;
            --length;
        }
        context.first = false;
        int fragmentLength = length - begin + offset;
        this.delegate.transform(session, input, begin, fragmentLength, isLastFragment, output);
        if (isLastFragment) {
            context.reset();
        }
    }

    private int processUnicode(Session session, ByteBuf data, int offset, int length, boolean isLastPart, ByteBuf output, Context context, int i) {
        while (i < length && context.unicodeDigits < 4) {
            context.unicodeChar *= 16;
            byte b = data.getByte(offset + i);
            if (b >= 48 && b <= 57) {
                context.unicodeChar += b - 48;
            } else if (b >= 97 && b <= 102) {
                context.unicodeChar += 10 + b - 97;
            } else if (b >= 65 && b <= 70) {
                context.unicodeChar += 10 + b - 65;
            } else assert (false);
            ++context.unicodeDigits;
            ++i;
        }
        if (context.unicodeDigits == 4) {
            ByteBuf utf8 = Unpooled.wrappedBuffer((byte[])Character.toString((char)context.unicodeChar).getBytes(StandardCharsets.UTF_8));
            this.delegate.transform(session, utf8, utf8.readerIndex(), utf8.readableBytes(), isLastPart && i == length - 1, output);
            context.unicode = false;
            context.unicodeChar = 0;
            context.unicodeDigits = 0;
        }
        return i;
    }

    public void after(Session session) {
        this.delegate.after(session);
    }

    public void reserve(Session session) {
        session.declareResource((Session.ResourceKey)this, Context::new);
    }

    public static class Context
    implements Session.Resource {
        private int unicodeDigits;
        private int unicodeChar;
        private boolean first = true;
        private boolean escaped;
        private boolean unicode;

        private void reset() {
            this.first = true;
            this.escaped = false;
            this.unicode = false;
            this.unicodeDigits = 0;
            this.unicodeChar = 0;
        }
    }
}

