/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.hooks;

import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.RunHook;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecRunHook
extends RunHook {
    private static final Logger log = LogManager.getLogger(ExecRunHook.class);
    private final String command;

    public ExecRunHook(String name, String command) {
        super(name);
        this.command = command;
    }

    public boolean run(Map<String, String> properties, Consumer<String> outputConsumer) {
        ProcessBuilder pb = new ProcessBuilder("sh", "-c", this.command).inheritIO().redirectOutput(ProcessBuilder.Redirect.PIPE);
        pb.environment().putAll(properties);
        try {
            log.info("{}: Starting command {}", (Object)this.name, (Object)this.command);
            Process process = pb.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    log.trace(line);
                    outputConsumer.accept(line);
                    outputConsumer.accept("\n");
                }
            }
            int exitValue = process.waitFor();
            log.info("{}: Completed command with exit code {}", (Object)this.name, (Object)exitValue);
            return exitValue == 0;
        }
        catch (IOException e) {
            log.error("Cannot start " + this.name, (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            log.error("Interrupted during hook execution", (Throwable)e);
            return false;
        }
    }

    @Name(value="exec")
    public static class Builder
    implements RunHook.Builder,
    InitFromParam<Builder> {
        private String cmd;

        public Builder init(String param) {
            this.cmd = param;
            return this;
        }

        public RunHook build(String name) {
            return new ExecRunHook(name, this.cmd);
        }
    }
}

