/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl;

import io.hyperfoil.internal.Properties;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;

public abstract class EventLoopFactory {
    public static final EventLoopFactory INSTANCE;

    public abstract EventLoopGroup create(int var1);

    public abstract Class<? extends SocketChannel> socketChannel();

    static {
        String transport = Properties.get((String)"io.hyperfoil.netty.transport", null);
        if (transport != null) {
            switch (transport.toLowerCase()) {
                case "nio": {
                    INSTANCE = new NioEventLoopFactory();
                    break;
                }
                case "epoll": {
                    INSTANCE = new EpollEventLoopFactory();
                    break;
                }
                case "kqueue": {
                    INSTANCE = new KqueueEventLoopFactory();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown transport '" + transport + "', use either 'nio' or 'epoll'.");
                }
            }
        } else {
            INSTANCE = Epoll.isAvailable() ? new EpollEventLoopFactory() : (KQueue.isAvailable() ? new KqueueEventLoopFactory() : new NioEventLoopFactory());
        }
    }

    private static class KqueueEventLoopFactory
    extends EventLoopFactory {
        private KqueueEventLoopFactory() {
        }

        @Override
        public EventLoopGroup create(int threads) {
            return new KQueueEventLoopGroup(threads);
        }

        @Override
        public Class<? extends SocketChannel> socketChannel() {
            return KQueueSocketChannel.class;
        }
    }

    private static class EpollEventLoopFactory
    extends EventLoopFactory {
        private EpollEventLoopFactory() {
        }

        @Override
        public EventLoopGroup create(int threads) {
            return new EpollEventLoopGroup(threads);
        }

        @Override
        public Class<? extends SocketChannel> socketChannel() {
            return EpollSocketChannel.class;
        }
    }

    private static class NioEventLoopFactory
    extends EventLoopFactory {
        private NioEventLoopFactory() {
        }

        @Override
        public EventLoopGroup create(int threads) {
            return new NioEventLoopGroup(threads);
        }

        @Override
        public Class<? extends SocketChannel> socketChannel() {
            return NioSocketChannel.class;
        }
    }
}

