/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BenchmarkSource;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.core.api.Plugin;
import io.hyperfoil.core.parser.AbstractMappingParser;
import io.hyperfoil.core.parser.Adapter;
import io.hyperfoil.core.parser.AgentsParser;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.DebugIterator;
import io.hyperfoil.core.parser.ErgonomicsParser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.PhaseParser;
import io.hyperfoil.core.parser.PhasesParser;
import io.hyperfoil.core.parser.PropertyParser;
import io.hyperfoil.core.parser.RunHooksParser;
import io.hyperfoil.core.parser.ScenarioParser;
import io.hyperfoil.core.parser.StaircaseParser;
import io.hyperfoil.core.parser.TemplateIterator;
import io.hyperfoil.impl.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.events.CollectionEndEvent;
import org.yaml.snakeyaml.events.CollectionStartEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;

public class BenchmarkParser
extends AbstractMappingParser<BenchmarkBuilder> {
    private static final Logger log = LogManager.getLogger(BenchmarkParser.class);
    private static final BenchmarkParser INSTANCE = new BenchmarkParser();
    private static final boolean DEBUG_PARSER = Boolean.getBoolean("io.hyperfoil.parser.debug");

    public static BenchmarkParser instance() {
        return INSTANCE;
    }

    private BenchmarkParser() {
        this.register("$schema", new PropertyParser.String<BenchmarkBuilder>(this::checkSchema));
        this.register("name", new PropertyParser.String<BenchmarkBuilder>(BenchmarkBuilder::name));
        this.register("agents", new AgentsParser());
        this.register("ergonomics", new ErgonomicsParser());
        this.register("failurePolicy", new PropertyParser.Enum((Enum[])Benchmark.FailurePolicy.values(), BenchmarkBuilder::failurePolicy));
        this.register("phases", new PhasesParser());
        this.register("threads", new PropertyParser.Int<BenchmarkBuilder>(BenchmarkBuilder::threads));
        this.register("statisticsCollectionPeriod", new PropertyParser.Int<BenchmarkBuilder>(BenchmarkBuilder::statisticsCollectionPeriod));
        this.register("usersPerSec", new PropertyParser.Double<BenchmarkBuilder>((bb, value) -> bb.singleConstantRatePhase().usersPerSec(value.doubleValue())));
        this.register("duration", new PropertyParser.TimeMillis<BenchmarkBuilder>((bb, value) -> bb.singleConstantRatePhase().duration(value.longValue())));
        this.register("maxDuration", new PropertyParser.TimeMillis<BenchmarkBuilder>((bb, value) -> bb.singleConstantRatePhase().maxDuration(value.longValue())));
        this.register("maxSessions", new PropertyParser.Int<BenchmarkBuilder>((bb, value) -> bb.singleConstantRatePhase().maxSessions(value.intValue())));
        this.register("scenario", (ctx, target) -> new ScenarioParser().parse(ctx, target.singleConstantRatePhase().scenario()));
        this.register("staircase", new StaircaseParser());
        this.register("customSla", new Adapter<BenchmarkBuilder, PhaseBuilder>(BenchmarkBuilder::singleConstantRatePhase, new PhaseParser.CustomSLAParser()));
        this.register("triggerUrl", new PropertyParser.String<BenchmarkBuilder>(BenchmarkBuilder::triggerUrl));
        this.register("pre", new RunHooksParser(BenchmarkBuilder::addPreHook));
        this.register("post", new RunHooksParser(BenchmarkBuilder::addPostHook));
        ServiceLoader.load(Plugin.class).forEach(instance -> this.register(instance.name(), instance.parser()));
    }

    private void checkSchema(BenchmarkBuilder builder, String schema) {
        if (schema.startsWith("http") && !schema.startsWith("http://hyperfoil.io/schema") && !schema.startsWith("https://hyperfoil.io/schema")) {
            log.warn("Unexpected schema: should start with `http://hyperfoil.io/schema`!");
        }
    }

    public Benchmark buildBenchmark(BenchmarkSource source, Map<String, String> templateParams) throws ParserException {
        return this.builder(source, templateParams).build();
    }

    public Benchmark buildBenchmark(InputStream inputStream, BenchmarkData data, Map<String, String> templateParams) throws ParserException, IOException {
        return this.builder(this.createSource(Util.toString((InputStream)inputStream), data), templateParams).build();
    }

    public BenchmarkBuilder builder(InputStream inputStream, BenchmarkData data, Map<String, String> templateParams) throws ParserException, IOException {
        return this.builder(this.createSource(Util.toString((InputStream)inputStream), data), templateParams);
    }

    public BenchmarkBuilder builder(BenchmarkSource source, Map<String, String> templateParams) throws ParserException {
        Yaml yaml = new Yaml();
        Iterator<Event> events = yaml.parse((Reader)new StringReader(source.yaml)).iterator();
        events = new TemplateIterator(events, templateParams);
        if (DEBUG_PARSER) {
            events = new DebugIterator<Event>(events);
        }
        Context ctx = new Context(events);
        ctx.expectEvent(StreamStartEvent.class);
        ctx.expectEvent(DocumentStartEvent.class);
        final BenchmarkBuilder benchmarkBuilder = new BenchmarkBuilder(source, templateParams);
        Locator.push((Locator)new Locator.Abstract(){

            public BenchmarkBuilder benchmark() {
                return benchmarkBuilder;
            }
        });
        try {
            this.parse(ctx, benchmarkBuilder);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ParserException) {
                throw (ParserException)e.getCause();
            }
            throw e;
        }
        finally {
            Locator.pop();
        }
        ctx.expectEvent(DocumentEndEvent.class);
        ctx.expectEvent(StreamEndEvent.class);
        return benchmarkBuilder;
    }

    public BenchmarkSource createSource(String source, BenchmarkData data) throws ParserException {
        Yaml yaml = new Yaml();
        HashMap<String, String> paramsWithDefaults = new HashMap<String, String>();
        String name = null;
        int depth = 0;
        boolean isValue = false;
        boolean isName = false;
        for (Event event : yaml.parse((Reader)new StringReader(source))) {
            if (event instanceof ScalarEvent) {
                ScalarEvent se = (ScalarEvent)event;
                if ("!param".equalsIgnoreCase(se.getTag())) {
                    String value = se.getValue();
                    if (value.isEmpty()) {
                        throw new ParserException(event, "Cannot use !param with empty value!");
                    }
                    String[] parts = value.split(" +", 2);
                    paramsWithDefaults.put(parts[0], parts.length > 1 ? parts[1] : null);
                } else if (isName) {
                    name = se.getValue();
                }
                isValue = !isValue;
                isName = depth == 1 && isValue && "name".equals(se.getValue());
                continue;
            }
            if (event instanceof CollectionStartEvent) {
                ++depth;
                continue;
            }
            if (!(event instanceof CollectionEndEvent)) continue;
            --depth;
            isValue = false;
        }
        if (name == null) {
            throw new BenchmarkDefinitionException("Cannot find name for this benchmark");
        }
        return new BenchmarkSource(name, source, data, paramsWithDefaults);
    }
}

