/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.core.parser.AbstractMappingParser;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.Parser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.PropertyParser;
import java.util.function.Function;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;

public class IncrementPropertyParser<T, V>
implements Parser<T> {
    private final IncrementPropertyConsumer<T, V> consumer;
    private final Function<String, V> conversion;

    IncrementPropertyParser(IncrementPropertyConsumer<T, V> consumer, Function<String, V> conversion) {
        this.consumer = consumer;
        this.conversion = conversion;
    }

    @Override
    public void parse(Context ctx, T target) throws ParserException {
        Event event = ctx.peek();
        if (event instanceof ScalarEvent) {
            this.consumer.accept(target, this.conversion.apply(((ScalarEvent)event).getValue()), this.conversion.apply(null));
            ctx.consumePeeked(event);
        } else if (event instanceof MappingStartEvent) {
            MappedValue mv = new MappedValue();
            MappingParser.INSTANCE.parse(ctx, mv);
            this.consumer.accept(target, this.conversion.apply(mv.base), this.conversion.apply(mv.increment));
        } else {
            throw ctx.unexpectedEvent(event);
        }
    }

    static class Int<T>
    extends IncrementPropertyParser<T, Integer> {
        Int(IncrementPropertyConsumer<T, Integer> consumer) {
            super(consumer, value -> value == null ? 0 : Integer.parseInt(value));
        }
    }

    static class Double<T>
    extends IncrementPropertyParser<T, java.lang.Double> {
        Double(IncrementPropertyConsumer<T, java.lang.Double> consumer) {
            super(consumer, value -> value == null ? 0.0 : java.lang.Double.parseDouble(value));
        }
    }

    @FunctionalInterface
    static interface IncrementPropertyConsumer<T, V> {
        public void accept(T var1, V var2, V var3);
    }

    private static class MappingParser
    extends AbstractMappingParser<MappedValue> {
        static MappingParser INSTANCE = new MappingParser();

        MappingParser() {
            this.register("base", new PropertyParser.String<MappedValue>((mv, value) -> {
                mv.base = value;
            }));
            this.register("increment", new PropertyParser.String<MappedValue>((mv, value) -> {
                mv.increment = value;
            }));
        }
    }

    private static class MappedValue {
        String base;
        String increment;

        private MappedValue() {
        }
    }
}

