/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.Model;
import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.api.config.SLABuilder;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.config.SessionLimitPolicy;
import io.hyperfoil.core.parser.AbstractParser;
import io.hyperfoil.core.parser.Adapter;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.IncrementPropertyParser;
import io.hyperfoil.core.parser.Parser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.PhaseForkParser;
import io.hyperfoil.core.parser.PropertyParser;
import io.hyperfoil.core.parser.ReflectionParser;
import io.hyperfoil.core.parser.ScenarioParser;
import io.hyperfoil.core.parser.StartAfterParser;
import io.hyperfoil.core.parser.StartWithParser;
import java.util.function.Predicate;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

abstract class PhaseParser
extends AbstractParser<PhaseBuilder.Catalog, PhaseBuilder<?>> {
    PhaseParser() {
        this.register("startTime", new PropertyParser.TimeMillis<PhaseBuilder>(PhaseBuilder::startTime));
        this.register("startAfter", new StartAfterParser(PhaseBuilder::startAfter));
        this.register("startAfterStrict", new StartAfterParser(PhaseBuilder::startAfterStrict));
        this.register("duration", new PropertyParser.TimeMillis<PhaseBuilder>(PhaseBuilder::duration));
        this.register("maxDuration", new PropertyParser.TimeMillis<PhaseBuilder>(PhaseBuilder::maxDuration));
        this.register("maxIterations", new PropertyParser.Int<PhaseBuilder>(PhaseBuilder::maxIterations));
        this.register("isWarmup", new PropertyParser.Boolean<PhaseBuilder>(PhaseBuilder::isWarmup));
        this.register("customSla", new CustomSLAParser());
        this.register("startWith", new StartWithParser(PhaseBuilder::startWith));
    }

    @Override
    public void parse(Context ctx, PhaseBuilder.Catalog target) throws ParserException {
        this.callSubBuilders(ctx, this.type(target));
    }

    protected abstract PhaseBuilder<?> type(PhaseBuilder.Catalog var1);

    static class CustomSLAParser
    implements Parser<PhaseBuilder<?>> {
        CustomSLAParser() {
        }

        @Override
        public void parse(Context ctx, PhaseBuilder<?> target) throws ParserException {
            ctx.expectEvent(MappingStartEvent.class);
            while (ctx.hasNext()) {
                Event next = ctx.next();
                if (next instanceof MappingEndEvent) {
                    return;
                }
                if (next instanceof ScalarEvent) {
                    ScalarEvent event = (ScalarEvent)next;
                    String metricName = event.getValue();
                    Event peeked = ctx.peek();
                    if (peeked instanceof MappingStartEvent) {
                        this.parseCustomSla(ctx, target, metricName);
                        continue;
                    }
                    if (peeked instanceof SequenceStartEvent) {
                        ctx.parseList(target, (ctx2, target2) -> this.parseCustomSla(ctx2, (PhaseBuilder<?>)target2, metricName));
                        continue;
                    }
                    throw ctx.unexpectedEvent(peeked);
                }
                throw ctx.unexpectedEvent(next);
            }
            throw ctx.noMoreEvents(MappingEndEvent.class);
        }

        private void parseCustomSla(Context ctx, PhaseBuilder<?> target, String metricName) throws ParserException {
            ReflectionParser<PhaseBuilder, SLABuilder> parser = new ReflectionParser<PhaseBuilder, SLABuilder>(t -> t.customSla(metricName));
            parser.parse(ctx, target);
        }
    }

    static class ConstantRate
    extends OpenModel {
        ConstantRate() {
            this.register("usersPerSec", new IncrementPropertyParser.Double<PhaseBuilder>((builder, base, inc) -> ((PhaseBuilder.ConstantRate)builder).usersPerSec(base.doubleValue(), inc.doubleValue())));
        }

        protected PhaseBuilder.ConstantRate type(PhaseBuilder.Catalog catalog) {
            return catalog.constantRate(-1);
        }
    }

    static class RampRate
    extends OpenModel {
        Predicate<Model.RampRate> constraint;
        String constraintMessage;

        RampRate() {
            this.register("initialUsersPerSec", new IncrementPropertyParser.Double<PhaseBuilder>((builder, base, inc) -> ((PhaseBuilder.RampRate)builder).initialUsersPerSec(base.doubleValue(), inc.doubleValue())));
            this.register("targetUsersPerSec", new IncrementPropertyParser.Double<PhaseBuilder>((builder, base, inc) -> ((PhaseBuilder.RampRate)builder).targetUsersPerSec(base.doubleValue(), inc.doubleValue())));
        }

        protected PhaseBuilder.RampRate type(PhaseBuilder.Catalog catalog) {
            return catalog.rampRate(-1, -1).constraint(this.constraint, this.constraintMessage);
        }

        RampRate constraint(Predicate<Model.RampRate> constraint, String message) {
            this.constraint = constraint;
            this.constraintMessage = message;
            return this;
        }
    }

    static abstract class OpenModel
    extends BasePhaseParser {
        OpenModel() {
            this.register("maxSessions", new PropertyParser.Int<PhaseBuilder>((builder, sessions) -> ((PhaseBuilder.OpenModel)builder).maxSessions(sessions.intValue())));
            this.register("variance", new PropertyParser.Boolean<PhaseBuilder>((builder, variance) -> ((PhaseBuilder.OpenModel)builder).variance(variance.booleanValue())));
            this.register("sessionLimitPolicy", new PropertyParser.Enum((Enum[])SessionLimitPolicy.values(), (builder, policy) -> ((PhaseBuilder.OpenModel)builder).sessionLimitPolicy(policy)));
        }
    }

    static class Always
    extends BasePhaseParser {
        Always() {
            this.register("users", new IncrementPropertyParser.Int<PhaseBuilder>((builder, base, inc) -> ((PhaseBuilder.Always)builder).users(base.intValue(), inc.intValue())));
            this.register("usersPerAgent", new PropertyParser.Int<PhaseBuilder>((builder, users) -> ((PhaseBuilder.Always)builder).usersPerAgent(users.intValue())));
            this.register("usersPerThread", new PropertyParser.Int<PhaseBuilder>((builder, users) -> ((PhaseBuilder.Always)builder).usersPerThread(users.intValue())));
        }

        protected PhaseBuilder.Always type(PhaseBuilder.Catalog catalog) {
            return catalog.always(-1);
        }
    }

    static class AtOnce
    extends BasePhaseParser {
        AtOnce() {
            this.register("users", new IncrementPropertyParser.Int<PhaseBuilder>((builder, base, inc) -> ((PhaseBuilder.AtOnce)builder).users(base.intValue(), inc.intValue())));
            this.register("usersPerAgent", new PropertyParser.Int<PhaseBuilder>((builder, users) -> ((PhaseBuilder.AtOnce)builder).usersPerAgent(users.intValue())));
            this.register("usersPerThread", new PropertyParser.Int<PhaseBuilder>((builder, users) -> ((PhaseBuilder.AtOnce)builder).usersPerThread(users.intValue())));
        }

        protected PhaseBuilder.AtOnce type(PhaseBuilder.Catalog catalog) {
            return catalog.atOnce(-1);
        }
    }

    static abstract class BasePhaseParser
    extends PhaseParser {
        BasePhaseParser() {
            this.register("scenario", new Adapter<PhaseBuilder, ScenarioBuilder>(PhaseBuilder::scenario, new ScenarioParser()));
            this.register("forks", new PhaseForkParser());
        }
    }

    static class Noop
    extends PhaseParser {
        Noop() {
        }

        @Override
        protected PhaseBuilder<?> type(PhaseBuilder.Catalog catalog) {
            return catalog.noop();
        }
    }
}

