/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.Parser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.impl.Util;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ScalarEvent;

public class PropertyParser {
    private PropertyParser() {
    }

    public static class TimeMillis<T>
    implements Parser<T> {
        private final BiConsumer<T, java.lang.Long> consumer;

        public TimeMillis(BiConsumer<T, java.lang.Long> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void parse(Context ctx, T target) throws ParserException {
            ScalarEvent event = ctx.expectEvent(ScalarEvent.class);
            try {
                this.consumer.accept(target, Util.parseToMillis((java.lang.String)event.getValue()));
            }
            catch (NumberFormatException e) {
                throw new ParserException((Event)event, "Failed to parse as long: " + event.getValue());
            }
        }
    }

    public static class Enum<E extends java.lang.Enum<E>, T>
    implements Parser<T> {
        private final E[] values;
        private final BiConsumer<T, E> consumer;

        public Enum(E[] values, BiConsumer<T, E> consumer) {
            this.values = values;
            this.consumer = consumer;
        }

        @Override
        public void parse(Context ctx, T target) throws ParserException {
            ScalarEvent event = ctx.expectEvent(ScalarEvent.class);
            for (E value : this.values) {
                if (!((java.lang.Enum)value).name().equalsIgnoreCase(event.getValue())) continue;
                this.consumer.accept(target, value);
                return;
            }
            throw new ParserException("No match for enum value '" + event.getValue() + "', options are: " + Arrays.toString(this.values));
        }
    }

    public static class Boolean<T>
    implements Parser<T> {
        private final BiConsumer<T, java.lang.Boolean> consumer;

        public Boolean(BiConsumer<T, java.lang.Boolean> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void parse(Context ctx, T target) throws ParserException {
            boolean value;
            ScalarEvent event = ctx.expectEvent(ScalarEvent.class);
            if (event.getValue().equalsIgnoreCase("true")) {
                value = true;
            } else if (event.getValue().equalsIgnoreCase("false")) {
                value = false;
            } else {
                throw new ParserException("Failed to parse as boolean: " + event.getValue());
            }
            this.consumer.accept(target, value);
        }
    }

    public static class Double<T>
    implements Parser<T> {
        private final BiConsumer<T, java.lang.Double> consumer;

        public Double(BiConsumer<T, java.lang.Double> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void parse(Context ctx, T target) throws ParserException {
            ScalarEvent event = ctx.expectEvent(ScalarEvent.class);
            try {
                this.consumer.accept(target, java.lang.Double.parseDouble(event.getValue()));
            }
            catch (NumberFormatException e) {
                throw new ParserException((Event)event, "Failed to parse as long: " + event.getValue());
            }
        }
    }

    public static class Long<T>
    implements Parser<T> {
        private final BiConsumer<T, java.lang.Long> consumer;

        public Long(BiConsumer<T, java.lang.Long> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void parse(Context ctx, T target) throws ParserException {
            ScalarEvent event = ctx.expectEvent(ScalarEvent.class);
            try {
                this.consumer.accept(target, java.lang.Long.parseLong(event.getValue()));
            }
            catch (NumberFormatException e) {
                throw new ParserException((Event)event, "Failed to parse as long: " + event.getValue());
            }
        }
    }

    public static class Int<T>
    implements Parser<T> {
        private final BiConsumer<T, Integer> consumer;

        public Int(BiConsumer<T, Integer> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void parse(Context ctx, T target) throws ParserException {
            ScalarEvent event = ctx.expectEvent(ScalarEvent.class);
            try {
                this.consumer.accept(target, Integer.parseInt(event.getValue()));
            }
            catch (NumberFormatException e) {
                throw new ParserException((Event)event, "Failed to parse as integer: " + event.getValue());
            }
        }
    }

    public static class String<T>
    implements Parser<T> {
        private final BiConsumer<T, java.lang.String> consumer;

        public String(BiConsumer<T, java.lang.String> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void parse(Context ctx, T target) throws ParserException {
            ScalarEvent event = ctx.expectEvent(ScalarEvent.class);
            this.consumer.accept(target, event.getValue());
        }
    }
}

