/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.config.SequenceBuilder;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.Parser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.StepParser;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

class SequenceParser
implements Parser<ScenarioBuilder> {
    private final Supplier supplier;

    SequenceParser(Supplier supplier) {
        this.supplier = supplier;
    }

    @Override
    public void parse(Context ctx, ScenarioBuilder target) throws ParserException {
        ctx.parseList(target, this::parseSequence);
    }

    private void parseSequence(Context ctx, ScenarioBuilder target) throws ParserException {
        ctx.expectEvent(MappingStartEvent.class);
        ScalarEvent sequenceNameEvent = ctx.expectEvent(ScalarEvent.class);
        SequenceParser.parseSequence(ctx, sequenceNameEvent.getValue(), target, this.supplier);
        ctx.expectEvent(MappingEndEvent.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SequenceBuilder parseSequence(Context ctx, String name, ScenarioBuilder scenario, Supplier supplier) throws ParserException {
        Event event = ctx.peek();
        if (event instanceof SequenceStartEvent) {
            SequenceBuilder sequence = supplier.get(scenario, name, null);
            Locator.push(null, (BaseSequenceBuilder)sequence);
            try {
                ctx.parseList(sequence, StepParser.instance());
            }
            finally {
                Locator.pop();
            }
            return sequence;
        }
        if (event instanceof ScalarEvent) {
            String value = ((ScalarEvent)event).getValue();
            if (value == null || value.isEmpty()) {
                throw new ParserException(event, "The sequence must not be empty.");
            }
            throw new ParserException(event, "Expected sequence of steps but got '" + value + "'");
        }
        throw ctx.unexpectedEvent(event);
    }

    static interface Supplier {
        public SequenceBuilder get(ScenarioBuilder var1, String var2, SequenceBuilder var3);
    }
}

