/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.api.config.PhaseReference;
import io.hyperfoil.api.config.RelativeIteration;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.core.parser.AbstractParser;
import io.hyperfoil.core.parser.Adapter;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.PhaseForkParser;
import io.hyperfoil.core.parser.PhaseParser;
import io.hyperfoil.core.parser.PropertyParser;
import io.hyperfoil.core.parser.ScenarioParser;
import io.hyperfoil.impl.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class StaircaseParser
extends AbstractParser<BenchmarkBuilder, StaircaseBuilder> {
    private static final Logger log = LogManager.getLogger(StaircaseParser.class);

    StaircaseParser() {
        this.register("initialRampUpDuration", new PropertyParser.String<StaircaseBuilder>(StaircaseBuilder::initialRampUpDuration));
        this.register("steadyStateDuration", new PropertyParser.String<StaircaseBuilder>(StaircaseBuilder::steadyStateDuration));
        this.register("rampUpDuration", new PropertyParser.String<StaircaseBuilder>(StaircaseBuilder::rampUpDuration));
        this.register("initialUsersPerSec", new PropertyParser.Double<StaircaseBuilder>(StaircaseBuilder::initialUsersPerSec));
        this.register("incrementUsersPerSec", new PropertyParser.Double<StaircaseBuilder>(StaircaseBuilder::incrementUsersPerSec));
        this.register("maxIterations", new PropertyParser.Int<StaircaseBuilder>(StaircaseBuilder::maxIterations));
        this.register("maxSessions", new PropertyParser.Int<StaircaseBuilder>(StaircaseBuilder::maxSessions));
        this.register("scenario", new Adapter<StaircaseBuilder, ScenarioBuilder>(StaircaseBuilder::scenario, new ScenarioParser()));
        this.register("forks", new Adapter<StaircaseBuilder, PhaseBuilder>(StaircaseBuilder::phase, new PhaseForkParser()));
        this.register("customSla", new Adapter<StaircaseBuilder, PhaseBuilder>(StaircaseBuilder::phase, new PhaseParser.CustomSLAParser()));
    }

    @Override
    public void parse(Context ctx, BenchmarkBuilder target) throws ParserException {
        StaircaseBuilder builder = new StaircaseBuilder(target);
        this.callSubBuilders(ctx, builder);
        builder.apply();
    }

    static class StaircaseBuilder {
        private final BenchmarkBuilder benchmark;
        private final PhaseBuilder.ConstantRate steadyState;
        private long initialRampUpDuration;
        private long steadyStateDuration;
        private long rampUpDuration;
        private long maxOverrun;
        private double initialUsersPerSec;
        private double incrementUsersPerSec;
        private int maxIterations;
        private int maxSessions;

        StaircaseBuilder(BenchmarkBuilder benchmark) {
            this.benchmark = benchmark;
            this.steadyState = benchmark.addPhase("steadyState").constantRate(0);
        }

        public void initialRampUpDuration(String duration) {
            this.initialRampUpDuration = Util.parseToMillis((String)duration);
        }

        public void steadyStateDuration(String duration) {
            this.steadyStateDuration = Util.parseToMillis((String)duration);
        }

        public void rampUpDuration(String duration) {
            this.rampUpDuration = Util.parseToMillis((String)duration);
        }

        public void maxOverrun(String duration) {
            this.maxOverrun = Util.parseToMillis((String)duration);
        }

        public void initialUsersPerSec(double usersPerSec) {
            this.initialUsersPerSec = usersPerSec;
        }

        public void incrementUsersPerSec(double usersPerSec) {
            this.incrementUsersPerSec = usersPerSec;
        }

        public void maxIterations(int iterations) {
            this.maxIterations = iterations;
        }

        public void maxSessions(int sessions) {
            this.maxSessions = sessions;
        }

        public ScenarioBuilder scenario() {
            return this.steadyState.scenario();
        }

        public PhaseBuilder<?> phase() {
            return this.steadyState;
        }

        public void apply() {
            if (this.steadyStateDuration <= 0L) {
                throw new BenchmarkDefinitionException("Staircase must define 'steadyStateDuration'");
            }
            if (this.maxIterations <= 0) {
                throw new BenchmarkDefinitionException("Staircase must define 'maxIterations'");
            }
            if (this.incrementUsersPerSec <= 0.0) {
                throw new BenchmarkDefinitionException("Staircase must define 'incrementUsersPerSec'");
            }
            if (this.initialUsersPerSec <= 0.0) {
                this.initialUsersPerSec = this.incrementUsersPerSec;
            }
            ((PhaseBuilder.ConstantRate)this.steadyState.duration(this.steadyStateDuration)).usersPerSec(this.initialUsersPerSec, this.incrementUsersPerSec).maxIterations(this.maxIterations);
            if (this.maxOverrun > 0L) {
                this.steadyState.maxDuration(this.steadyStateDuration + this.maxOverrun);
            }
            if (this.maxSessions > 0) {
                this.steadyState.maxSessions(this.maxSessions);
            }
            if (this.initialRampUpDuration <= 0L) {
                this.initialRampUpDuration = this.rampUpDuration;
            }
            if (this.initialRampUpDuration > 0L) {
                PhaseBuilder.RampRate initialRampUp = (PhaseBuilder.RampRate)this.benchmark.addPhase("initialRampUp").rampRate(0, 0).targetUsersPerSec(this.initialUsersPerSec).duration(this.initialRampUpDuration);
                if (this.maxOverrun > 0L) {
                    initialRampUp.maxDuration(this.initialRampUpDuration + this.maxOverrun);
                }
                if (this.maxSessions > 0) {
                    initialRampUp.maxSessions(this.maxSessions);
                }
                this.steadyState.startAfter(initialRampUp.name());
                initialRampUp.readForksFrom((PhaseBuilder)this.steadyState);
                initialRampUp.readCustomSlaFrom((PhaseBuilder)this.steadyState);
            }
            if (this.rampUpDuration > 0L) {
                if (this.maxIterations > 1) {
                    PhaseBuilder.RampRate rampUp = (PhaseBuilder.RampRate)((PhaseBuilder.RampRate)((PhaseBuilder.RampRate)((PhaseBuilder.RampRate)this.benchmark.addPhase("rampUp").rampRate(0, 0).duration(this.rampUpDuration)).initialUsersPerSec(this.initialUsersPerSec, this.incrementUsersPerSec).targetUsersPerSec(this.initialUsersPerSec + this.incrementUsersPerSec, this.incrementUsersPerSec).maxIterations(this.maxIterations - 1)).forceIterations(true)).startAfter(new PhaseReference(this.steadyState.name(), RelativeIteration.SAME, null));
                    if (this.maxOverrun > 0L) {
                        rampUp.maxDuration(this.rampUpDuration + this.maxOverrun);
                    }
                    if (this.maxSessions > 0) {
                        rampUp.maxSessions(this.maxSessions);
                    }
                    if (this.maxIterations > 1) {
                        this.steadyState.startAfter(new PhaseReference(rampUp.name(), RelativeIteration.PREVIOUS, null));
                    }
                    rampUp.readForksFrom((PhaseBuilder)this.steadyState);
                    rampUp.readCustomSlaFrom((PhaseBuilder)this.steadyState);
                }
            } else {
                log.warn("No 'rampUpDuration' defined. There won't be continuous load.");
            }
        }
    }
}

