/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.print;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.config.Visitor;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.processor.Transformer;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.impl.ReflectionAcceptor;
import java.io.PrintStream;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Stream;

public class YamlVisitor
implements Visitor {
    private static final Class<?> BYTE_ARRAY = byte[].class;
    private static final Class<?> CHAR_ARRAY = char[].class;
    private int maxCollectionSize = 20;
    private int indent = 0;
    private boolean skipIndent = false;
    private boolean addLine = false;
    private final PrintStream stream;
    private Stack<Object> path = new Stack();

    public YamlVisitor(PrintStream stream, int maxCollectionSize) {
        this.stream = stream;
        this.maxCollectionSize = maxCollectionSize;
    }

    public void walk(Benchmark benchmark) {
        ReflectionAcceptor.accept((Object)benchmark, (Visitor)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visit(String name, Object value, Type fieldType) {
        if (value == null) {
            return false;
        }
        if (this.addLine) {
            this.stream.println();
            this.addLine = false;
        }
        if (this.skipIndent) {
            this.skipIndent = false;
        } else {
            this.printIndent();
        }
        if (name.contains(":")) {
            this.stream.print('\"');
            this.stream.print(name.replaceAll("\"", "\\\""));
            this.stream.print('\"');
        } else {
            this.stream.print(name);
        }
        this.stream.print(": ");
        if (this.path.contains(value)) {
            this.stream.println("<recursion detected>");
            return true;
        }
        this.path.push(value);
        try {
            this.printValue(value, false, fieldType);
        }
        finally {
            this.path.pop();
        }
        return true;
    }

    protected void printValue(Object value, boolean isList, Type fieldType) {
        if (ReflectionAcceptor.isScalar((Object)value)) {
            this.printMultiline(String.valueOf(value));
            return;
        }
        Class<?> cls = value.getClass();
        if (cls.isArray()) {
            if (BYTE_ARRAY.isInstance(value)) {
                this.printMultiline(new String((byte[])value, StandardCharsets.UTF_8));
            } else if (CHAR_ARRAY.isInstance(value)) {
                this.printMultiline(String.valueOf((char[])value));
            } else {
                this.printArray(value, cls);
            }
        } else if (Collection.class.isAssignableFrom(cls)) {
            this.printCollection(fieldType, (Collection)value);
        } else if (Map.class.isAssignableFrom(cls)) {
            this.printMap(fieldType, (Map)value);
        } else if (Sequence.class.isAssignableFrom(cls)) {
            this.printSequence((Sequence)value);
        } else if (Phase.class.isAssignableFrom(cls)) {
            this.printPhase((Phase)value, cls);
        } else if (Scenario.class.isAssignableFrom(cls)) {
            this.printScenario((Scenario)value);
        } else {
            boolean onlyImpl = this.isOnlyImpl(fieldType, cls);
            if (!onlyImpl) {
                this.indent += 2;
                if (!isList) {
                    this.stream.println();
                    this.printIndent();
                }
                this.stream.print(this.getName(value, cls));
                this.stream.print(": ");
                this.addLine = true;
                this.skipIndent = false;
            }
            if (!isList) {
                this.indent += 2;
                this.addLine = true;
                this.skipIndent = false;
            }
            if (ReflectionAcceptor.accept((Object)value, (Visitor)this) == 0) {
                this.stream.println("{}");
                this.addLine = false;
            }
            if (!onlyImpl) {
                this.indent -= 2;
            }
            if (!isList) {
                this.indent -= 2;
            }
        }
    }

    private void printMultiline(String s) {
        if (!s.contains("\n")) {
            this.stream.println(s);
            return;
        }
        this.stream.println("|+");
        this.indent += 2;
        for (String line : s.split("\n")) {
            this.printIndent();
            this.stream.println(line);
        }
        this.indent -= 2;
    }

    private void printArray(Object value, Class<?> cls) {
        int length = Array.getLength(value);
        if (length == 0) {
            this.stream.println("[]");
        } else {
            this.stream.println();
            if (length > this.maxCollectionSize) {
                this.printIndent();
                this.stream.printf("# Array has %d elements, printing first %d...%n", length, this.maxCollectionSize);
            }
            for (int i = 0; i < Math.min(length, this.maxCollectionSize); ++i) {
                this.printItem(Array.get(value, i), cls.getComponentType());
            }
            if (length > this.maxCollectionSize) {
                this.printIndent();
                this.stream.printf("# ... another %d/%d elements were truncated.%n", length - this.maxCollectionSize, length);
            }
        }
    }

    private void printCollection(Type fieldType, Collection<?> collection) {
        Type[] types;
        Object itemType = Object.class;
        if (fieldType instanceof ParameterizedType && Collection.class.isAssignableFrom((Class)((ParameterizedType)fieldType).getRawType()) && (types = ((ParameterizedType)fieldType).getActualTypeArguments()).length >= 1) {
            itemType = types[0];
        }
        if (collection.isEmpty()) {
            this.stream.println("[]");
        } else {
            int size = collection.size();
            this.stream.println();
            if (size > this.maxCollectionSize) {
                this.printIndent();
                this.stream.printf("# Collection has %d elements, printing first %d...%n", size, this.maxCollectionSize);
            }
            int counter = 0;
            for (Object item : collection) {
                this.printItem(item, (Type)itemType);
                if (counter++ < this.maxCollectionSize) continue;
                break;
            }
            if (size > this.maxCollectionSize) {
                this.printIndent();
                this.stream.printf("# ... another %d/%d elements were truncated.%n", size - this.maxCollectionSize, size);
            }
        }
    }

    private void printMap(Type fieldType, Map<?, ?> map) {
        Type[] types;
        Object valueType = Object.class;
        if (fieldType instanceof ParameterizedType && Map.class.isAssignableFrom((Class)((ParameterizedType)fieldType).getRawType()) && (types = ((ParameterizedType)fieldType).getActualTypeArguments()).length >= 2) {
            valueType = types[1];
        }
        if (map.isEmpty()) {
            this.stream.println("{}");
        } else {
            this.stream.println();
            this.indent += 2;
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                this.visit(String.valueOf(entry.getKey()), entry.getValue(), (Type)valueType);
            }
            this.indent -= 2;
        }
    }

    private void printSequence(Sequence seq) {
        this.stream.print(seq.name());
        if (seq.concurrency() > 0) {
            this.stream.printf("[%d]", seq.concurrency());
        }
        this.stream.println(": ");
        for (Step step : seq.steps()) {
            this.printItem(step, (Type)((Object)Step.class));
        }
    }

    private void printPhase(Phase phase, Class<?> cls) {
        this.stream.print(phase.name);
        this.stream.println(": ");
        this.indent += 2;
        this.printIndent();
        this.stream.print(this.getName(phase, cls));
        this.stream.println(": ");
        this.skipIndent = false;
        this.indent += 2;
        ReflectionAcceptor.accept((Object)phase, (Visitor)this);
        this.indent -= 4;
    }

    private void printScenario(Scenario scenario) {
        this.stream.println();
        this.indent += 2;
        this.printIndent();
        this.stream.println("initialSequences:");
        for (Sequence s2 : scenario.initialSequences()) {
            this.printItem(s2, (Type)((Object)Sequence.class));
        }
        this.printIndent();
        this.stream.println("sequences:");
        Stream.of(scenario.sequences()).filter(s -> Stream.of(scenario.initialSequences()).noneMatch(s2 -> s == s2)).forEach(s -> this.printItem(s, (Type)((Object)Sequence.class)));
        this.indent -= 2;
    }

    private String getName(Object value, Class<?> cls) {
        String suffix = Stream.of(Step.class, Action.class, Processor.class, Transformer.class).filter(c -> c.isAssignableFrom(cls)).map(Class::getSimpleName).findFirst().orElse(null);
        Class<?> clazz = value.getClass();
        String name = clazz.getSimpleName();
        if (clazz.isSynthetic()) {
            return this.lambdaName(value, clazz);
        }
        if (suffix != null && name.endsWith(suffix)) {
            return Character.toLowerCase(name.charAt(0)) + name.substring(1, name.length() - suffix.length());
        }
        if (clazz.isAnonymousClass()) {
            return this.anonymousName(clazz);
        }
        if (name.isEmpty()) {
            return "(empty:" + clazz.getName() + ")";
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private String anonymousName(Class<?> clazz) {
        Method method = clazz.getEnclosingMethod();
        if (method != null) {
            return clazz.getEnclosingClass().getSimpleName() + "." + method.getName() + "::(anonymous)";
        }
        Constructor<?> ctor = clazz.getEnclosingConstructor();
        if (ctor != null) {
            return clazz.getEnclosingClass().getSimpleName() + ".<init>::(anonymous)";
        }
        return clazz.getEnclosingClass().getSimpleName() + "::(anonymous)";
    }

    private boolean isOnlyImpl(Type fieldType, Class<?> cls) {
        if (fieldType == cls) {
            return true;
        }
        if (fieldType instanceof ParameterizedType) {
            return ((ParameterizedType)fieldType).getRawType() == cls;
        }
        return false;
    }

    private String lambdaName(Object value, Class<?> cls) {
        try {
            Method writeReplace = cls.getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            SerializedLambda serializedLambda = (SerializedLambda)writeReplace.invoke(value, new Object[0]);
            String implClass = serializedLambda.getImplClass();
            String methodName = serializedLambda.getImplMethodName();
            if (methodName.startsWith("lambda$")) {
                methodName = "(lambda)";
            }
            return implClass.substring(implClass.lastIndexOf(47) + 1) + "::" + methodName;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return "(lambda)";
        }
    }

    private void printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.stream.print(' ');
        }
    }

    private void printItem(Object item, Type fieldType) {
        if (item == null) {
            return;
        }
        this.printIndent();
        this.stream.print("- ");
        this.skipIndent = true;
        this.indent += 2;
        this.printValue(item, true, fieldType);
        this.indent -= 2;
        this.skipIndent = false;
    }
}

