/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.session;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.session.IntAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.IntVar;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SequenceScopedReadAccess;
import io.hyperfoil.core.session.SessionImpl;
import java.util.Arrays;

class SequenceScopedIntAccess
extends SequenceScopedReadAccess
implements IntAccess {
    SequenceScopedIntAccess(Object key, int maxConcurrency) {
        super(key, maxConcurrency);
    }

    public Session.Var createVar(Session session, Session.Var existing) {
        SessionImpl impl = (SessionImpl)session;
        if (existing == null) {
            existing = new ObjectVar(impl);
        } else if (!(existing instanceof ObjectVar)) {
            throw new BenchmarkDefinitionException("Variable " + this.key + " should hold an object but it is defined to hold an integer elsewhere.");
        }
        Object contents = existing.objectValue(session);
        if (contents == null) {
            ((ObjectVar)existing).set(IntVar.newArray(session, this.maxConcurrency));
        } else if (contents instanceof IntVar[]) {
            IntVar[] oldArray = (IntVar[])contents;
            if (oldArray.length < this.maxConcurrency) {
                IntVar[] newArray = Arrays.copyOf(oldArray, this.maxConcurrency);
                for (int i = oldArray.length; i < newArray.length; ++i) {
                    newArray[i] = new IntVar(impl);
                }
                ((ObjectVar)existing).set(newArray);
            }
        } else {
            throw new BenchmarkDefinitionException("Unexpected content in " + this.key + ": should hold array of IntVar but holds " + contents);
        }
        return existing;
    }

    public void setInt(Session session, int value) {
        ObjectVar var = this.getVarToSet(session);
        Object o = this.getItemFromVar(session, var);
        if (o instanceof IntVar) {
            if (trace) {
                log.trace("#{} {}[{}] <- {}", (Object)session.uniqueId(), this.key, (Object)session.currentSequence().index(), (Object)value);
            }
        } else {
            int index = session.currentSequence().index();
            throw new IllegalStateException("Variable " + this.key + "[" + index + "] should contain IntVar but contains " + o);
        }
        ((IntVar)o).set(value);
    }

    public int addToInt(Session session, int delta) {
        Object o = this.getItem(session);
        if (o instanceof IntVar) {
            IntVar iv = (IntVar)o;
            if (!iv.isSet()) {
                int index = session.currentSequence().index();
                throw new IllegalStateException("Variable " + this.key + "[" + index + "] was not set yet!");
            }
            int prev = iv.intValue(session);
            if (trace) {
                log.trace("#{} {}[{}] += {}", (Object)session.uniqueId(), this.key, (Object)session.currentSequence().index(), (Object)delta);
            }
            iv.add(delta);
            return prev;
        }
        int index = session.currentSequence().index();
        throw new IllegalStateException("Variable " + this.key + "[" + index + "] should contain IntVar but contains " + o);
    }

    public void unset(Session session) {
        ObjectVar var = this.getVarToSet(session);
        Object o = this.getItemFromVar(session, var);
        if (o instanceof IntVar) {
            if (trace) {
                log.trace("#{} unset {}[{}]", (Object)session.uniqueId(), this.key, (Object)session.currentSequence().index());
            }
        } else {
            int index = session.currentSequence().index();
            throw new IllegalStateException("Variable " + this.key + "[" + index + "] should contain Session.Var(Object) but contains " + o);
        }
        ((IntVar)o).unset();
    }
}

