/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.session;

import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.BaseAccess;
import io.hyperfoil.core.session.IntVar;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SessionImpl;
import java.lang.reflect.Array;
import java.util.List;

class SequenceScopedReadAccess
extends BaseAccess {
    protected final int maxConcurrency;

    SequenceScopedReadAccess(Object key, int maxConcurrency) {
        super(key);
        this.maxConcurrency = maxConcurrency;
    }

    public boolean isSet(Session session) {
        SessionImpl impl = (SessionImpl)session;
        ObjectVar var = (ObjectVar)impl.getVar(this.index);
        if (!var.isSet()) {
            return false;
        }
        Object o = this.getItemFromVar(session, var);
        if (o instanceof Session.Var) {
            return ((Session.Var)o).isSet();
        }
        int index = session.currentSequence().index();
        throw new IllegalStateException("Variable " + this.key + "[" + index + "] should contain Session.Var but contains " + o);
    }

    public Object getObject(Session session) {
        Object o = this.getItem(session);
        if (o instanceof Session.Var) {
            Session.Var ov = (Session.Var)o;
            if (!ov.isSet()) {
                int index = session.currentSequence().index();
                throw new IllegalStateException("Variable " + this.key + "[" + index + "] was not set yet!");
            }
            return ov.objectValue(session);
        }
        int index = session.currentSequence().index();
        throw new IllegalStateException("Variable " + this.key + "[" + index + "] should contain ObjectVar but contains " + o);
    }

    public int getInt(Session session) {
        Object o = this.getItem(session);
        if (o instanceof IntVar) {
            IntVar iv = (IntVar)o;
            if (!iv.isSet()) {
                int index = session.currentSequence().index();
                throw new IllegalStateException("Variable " + this.key + "[" + index + "] was not set yet!");
            }
            return iv.intValue(session);
        }
        int index = session.currentSequence().index();
        throw new IllegalStateException("Variable " + this.key + "[" + index + "] should contain IntVar but contains " + o);
    }

    public Session.Var getVar(Session session) {
        Object o = this.getItem(session);
        if (o instanceof Session.Var) {
            return (Session.Var)o;
        }
        int index = session.currentSequence().index();
        throw new IllegalStateException("Variable " + this.key + "[" + index + "] should contain Session.Var but contains " + o);
    }

    public boolean isSequenceScoped() {
        return true;
    }

    public String toString() {
        return this.key + "[.]";
    }

    protected Object getItem(Session session) {
        SessionImpl impl = (SessionImpl)session;
        ObjectVar var = (ObjectVar)impl.getVar(this.index);
        if (!var.isSet()) {
            throw new IllegalStateException("Variable " + this.key + " is not set!");
        }
        return this.getItemFromVar(session, var);
    }

    protected Object getItemFromVar(Session session, ObjectVar var) {
        Object collection = var.objectValue(session);
        if (collection == null) {
            throw new IllegalStateException("Variable " + this.key + " is null!");
        }
        int index = session.currentSequence().index();
        if (index >= this.maxConcurrency) {
            throw new IllegalStateException("Variable " + this.key + " reads item at index " + index + " but the maximum concurrency is " + this.maxConcurrency);
        }
        if (collection.getClass().isArray()) {
            return Array.get(collection, index);
        }
        if (collection instanceof List) {
            return ((List)collection).get(index);
        }
        throw new IllegalStateException("Unknown type to access by index: " + collection);
    }

    protected ObjectVar getVarToSet(Session session) {
        SessionImpl impl = (SessionImpl)session;
        Object var = impl.getVar(this.index);
        if (var instanceof ObjectVar) {
            ObjectVar ov = (ObjectVar)var;
            ov.set = true;
            return ov;
        }
        throw new IllegalStateException("Variable " + this.key + " does not hold an object variable (cannot hold array).");
    }
}

