/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.session;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Model;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.IntAccess;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.WriteAccess;
import io.hyperfoil.core.impl.PhaseInstanceImpl;
import io.hyperfoil.core.session.SequenceScopedIntAccess;
import io.hyperfoil.core.session.SequenceScopedObjectAccess;
import io.hyperfoil.core.session.SequenceScopedReadAccess;
import io.hyperfoil.core.session.SessionImpl;
import io.hyperfoil.core.session.SimpleIntAccess;
import io.hyperfoil.core.session.SimpleObjectAccess;
import io.hyperfoil.core.session.SimpleReadAccess;
import io.hyperfoil.core.session.SpecialAccess;
import io.hyperfoil.core.util.Unique;
import io.hyperfoil.function.SerializableFunction;
import io.hyperfoil.function.SerializableToIntFunction;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.io.Serializable;
import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class SessionFactory {
    private static final SpecialAccess[] SPECIAL = new SpecialAccess[]{new SpecialAccess.Int("hyperfoil.agent.id", (SerializableToIntFunction<Session>)((SerializableToIntFunction & Serializable)Session::agentId)), new SpecialAccess.Int("hyperfoil.agents", (SerializableToIntFunction<Session>)((SerializableToIntFunction & Serializable)Session::agents)), new SpecialAccess.Int("hyperfoil.agent.thread.id", (SerializableToIntFunction<Session>)((SerializableToIntFunction & Serializable)Session::agentThreadId)), new SpecialAccess.Int("hyperfoil.agent.threads", (SerializableToIntFunction<Session>)((SerializableToIntFunction & Serializable)Session::agentThreads)), new SpecialAccess.Int("hyperfoil.global.thread.id", (SerializableToIntFunction<Session>)((SerializableToIntFunction & Serializable)Session::globalThreadId)), new SpecialAccess.Int("hyperfoil.global.threads", (SerializableToIntFunction<Session>)((SerializableToIntFunction & Serializable)Session::globalThreads)), new SpecialAccess.Object("hyperfoil.phase.name", (SerializableFunction<Session, Object>)(SerializableFunction & Serializable)s -> s.phase().definition().name), new SpecialAccess.Int("hyperfoil.phase.id", (SerializableToIntFunction<Session>)(SerializableToIntFunction & Serializable)s -> s.phase().definition().id), new SpecialAccess.Int("hyperfoil.phase.iteration", (SerializableToIntFunction<Session>)(SerializableToIntFunction & Serializable)s -> s.phase().definition().iteration), new SpecialAccess.Object("hyperfoil.phase.start.time.as.string", (SerializableFunction<Session, Object>)(SerializableFunction & Serializable)s -> s.phase().absoluteStartTimeAsString()), new SpecialAccess.Object("hyperfoil.run.id", (SerializableFunction<Session, Object>)((SerializableFunction & Serializable)Session::runId)), new SpecialAccess.Int("hyperfoil.session.id", (SerializableToIntFunction<Session>)((SerializableToIntFunction & Serializable)Session::uniqueId))};

    public static Session create(Scenario scenario, int executorId, int uniqueId) {
        return new SessionImpl(scenario, executorId, uniqueId);
    }

    public static Session forTesting(final WriteAccess ... accesses) {
        Scenario dummyScenario = new Scenario(new Sequence[0], new Sequence[]{new Sequence("dummy", 0, 1, 0, new Step[0]){
            WriteAccess[] dummyAccesses;
            {
                super(name, id, concurrency, offset, steps);
                this.dummyAccesses = accesses;
            }
        }}, 16, 16);
        SessionImpl session = new SessionImpl(dummyScenario, 0, 0);
        Phase dummyPhase = new Phase(Benchmark::forTesting, 0, 0, "dummy", dummyScenario, 0L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), 0L, -1L, null, false, (Model & Serializable)() -> "dummy", Collections.emptyMap(), null);
        session.resetPhase(new PhaseInstanceImpl(dummyPhase, "dummy", 0){

            public void proceed(EventExecutorGroup executorGroup) {
            }

            public void reserveSessions() {
            }
        });
        session.attach((EventExecutor)ImmediateEventExecutor.INSTANCE, null, null, null, null);
        session.reserve(dummyScenario);
        return session;
    }

    private SessionFactory() {
    }

    public static ReadAccess readAccess(Object key) {
        String expression;
        if (key instanceof String && (expression = (String)key).startsWith("hyperfoil.")) {
            for (SpecialAccess access : SPECIAL) {
                if (!access.name.equals(expression)) continue;
                return access;
            }
            throw new BenchmarkDefinitionException("No special variable " + expression);
        }
        return SessionFactory.access(key, SimpleReadAccess::new, SequenceScopedReadAccess::new);
    }

    public static ObjectAccess objectAccess(Object key) {
        return (ObjectAccess)SessionFactory.access(key, SimpleObjectAccess::new, SequenceScopedObjectAccess::new);
    }

    public static IntAccess intAccess(Object key) {
        return (IntAccess)SessionFactory.access(key, SimpleIntAccess::new, SequenceScopedIntAccess::new);
    }

    public static <A extends ReadAccess> A access(Object key, Function<Object, A> simple, BiFunction<Object, Integer, A> sequenceScoped) {
        assert (Locator.current() != null);
        if (key == null) {
            return null;
        }
        if (key instanceof String) {
            String expression = (String)key;
            if (expression.endsWith("[.]")) {
                return (A)((ReadAccess)sequenceScoped.apply(expression.substring(0, expression.length() - 3), SessionFactory.getMaxConcurrency()));
            }
            return (A)((ReadAccess)simple.apply(key));
        }
        if (key instanceof Unique) {
            if (((Unique)key).isSequenceScoped()) {
                return (A)((ReadAccess)sequenceScoped.apply(key, SessionFactory.getMaxConcurrency()));
            }
            return (A)((ReadAccess)simple.apply(key));
        }
        return (A)((ReadAccess)simple.apply(key));
    }

    public static ReadAccess sequenceScopedReadAccess(Object key) {
        return SessionFactory.sequenceScopedObjectAccess(key);
    }

    public static ObjectAccess sequenceScopedObjectAccess(Object key) {
        return new SequenceScopedObjectAccess(key, SessionFactory.getMaxConcurrency());
    }

    public static IntAccess sequenceScopedIntAccess(Object key) {
        return new SequenceScopedIntAccess(key, SessionFactory.getMaxConcurrency());
    }

    private static int getMaxConcurrency() {
        Locator locator = Locator.current();
        assert (locator != null);
        int maxConcurrency = locator.sequence().rootSequence().concurrency();
        if (maxConcurrency <= 0) {
            throw new BenchmarkDefinitionException(locator.step() + " in sequence " + locator.sequence().name() + " uses sequence-scoped access but this sequence is not declared as concurrent.");
        }
        return maxConcurrency;
    }

    public static void destroy(Session session) {
        ((SessionImpl)session).destroy();
    }
}

