/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.session;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.session.IntAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.IntVar;
import io.hyperfoil.core.session.SessionImpl;
import io.hyperfoil.core.session.SimpleReadAccess;

public class SimpleIntAccess
extends SimpleReadAccess
implements IntAccess {
    public SimpleIntAccess(Object key) {
        super(key);
    }

    public Session.Var createVar(Session session, Session.Var existing) {
        if (existing == null) {
            return new IntVar((SessionImpl)session);
        }
        if (existing instanceof IntVar) {
            return existing;
        }
        throw new BenchmarkDefinitionException("Variable " + this.key + " should hold an integer but it is defined to hold an object elsewhere.");
    }

    public void setInt(Session session, int value) {
        SessionImpl impl = (SessionImpl)session;
        if (trace) {
            log.trace("#{} {} <- {}", (Object)impl.uniqueId(), this.key, (Object)value);
        }
        ((IntVar)impl.getVar(this.index)).set(value);
    }

    public int addToInt(Session session, int delta) {
        SessionImpl impl = (SessionImpl)session;
        IntVar var = (IntVar)impl.requireSet(this.index, this.key);
        int prev = var.intValue(session);
        if (trace) {
            log.trace("#{} {} <- {}", (Object)impl.uniqueId(), this.key, (Object)(prev + delta));
        }
        var.set(prev + delta);
        return prev;
    }

    public void unset(Session session) {
        SessionImpl impl = (SessionImpl)session;
        impl.getVar(this.index).unset();
    }
}

