/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.session;

import io.hyperfoil.api.session.ThreadData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;

public class ThreadDataImpl
implements ThreadData {
    private final Map<String, SharedMapSet> maps = new HashMap<String, SharedMapSet>();
    private final Map<String, SharedCounterImpl> counters = new HashMap<String, SharedCounterImpl>();

    public void reserveMap(String key, Object match, int entries) {
        SharedMapSet existing = this.maps.get(key);
        if (existing != null) {
            if (match != null) {
                if (existing instanceof IndexedSharedMapSet) {
                    ((IndexedSharedMapSet)existing).ensureIndex(match).ensureEntries(entries);
                } else {
                    this.maps.put(key, new IndexedSharedMapSet(existing, match, entries));
                }
            } else {
                existing.ensureEntries(entries);
            }
        } else if (match != null) {
            this.maps.put(key, new IndexedSharedMapSet(match, entries));
        } else {
            this.maps.put(key, new SharedMapSet(entries));
        }
    }

    public ThreadData.SharedMap newMap(String key) {
        SharedMapSet set = this.maps.get(key);
        return set.newMap();
    }

    public ThreadData.SharedMap pullMap(String key) {
        return this.maps.get(key).acquireRandom();
    }

    public ThreadData.SharedMap pullMap(String key, Object match, Object value) {
        return this.maps.get(key).acquireRandom(match, value);
    }

    public void pushMap(String key, ThreadData.SharedMap sharedMap) {
        this.maps.get(key).insert(sharedMap);
    }

    public void releaseMap(String key, ThreadData.SharedMap map) {
        map.clear();
        this.maps.get(key).release(map);
    }

    public ThreadData.SharedCounter reserveCounter(String key) {
        SharedCounterImpl counter = this.counters.get(key);
        if (counter == null) {
            counter = new SharedCounterImpl();
            this.counters.put(key, counter);
        }
        return counter;
    }

    public ThreadData.SharedCounter getCounter(String key) {
        return this.counters.get(key);
    }

    private static class SharedCounterImpl
    implements ThreadData.SharedCounter {
        private long value;

        private SharedCounterImpl() {
        }

        public long get() {
            return this.value;
        }

        public long set(long value) {
            long prev = this.value;
            this.value = value;
            return prev;
        }

        public long apply(LongBinaryOperator operator, long value) {
            this.value = operator.applyAsLong(this.value, value);
            return this.value;
        }
    }

    private static class MapImpl
    implements ThreadData.SharedMap {
        int[] indexLocations;
        Object[] keys;
        Object[] values;
        int size;

        MapImpl(int capacity, int indices) {
            this.indexLocations = indices > 0 ? new int[indices] : null;
            this.keys = new Object[capacity];
            this.values = new Object[capacity];
        }

        public void put(Object key, Object value) {
            int pos = this.size++;
            this.keys[pos] = key;
            this.values[pos] = value;
        }

        public int size() {
            return this.size;
        }

        public int capacity() {
            return this.keys.length;
        }

        public void clear() {
            for (int i = this.size - 1; i >= 0; --i) {
                this.keys[i] = null;
                this.values[i] = null;
            }
            this.size = 0;
        }

        public Object get(Object key) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.keys[i].equals(key)) continue;
                return this.values[i];
            }
            throw new IllegalArgumentException("Looking for variable '" + key + "' but this is not set; Available: " + Arrays.asList(this.keys));
        }
    }

    private static class IndexedSharedMapSet
    extends SharedMapSet {
        private Positions[] unusedPositions = new Positions[16];
        private int unusedPositionsSize = 0;
        private Map<Object, Positions>[] positions;
        private Object[] indices;
        private final Function<Object, Positions> acquirePosition = ignored -> this.acquirePosition();

        IndexedSharedMapSet(Object indexKey, int entries) {
            super(entries);
            this.indices = new Object[]{indexKey};
            this.positions = new Map[]{new HashMap()};
        }

        IndexedSharedMapSet(SharedMapSet set, Object indexKey, int entries) {
            super(set, entries);
            this.indices = new Object[]{indexKey};
            this.positions = new Map[]{new HashMap()};
        }

        @Override
        protected int numIndices() {
            return this.indices.length;
        }

        IndexedSharedMapSet ensureIndex(Object index) {
            for (Object key : this.indices) {
                if (!key.equals(index)) continue;
                return this;
            }
            this.indices = Arrays.copyOf(this.indices, this.indices.length + 1);
            this.positions = Arrays.copyOf(this.positions, this.positions.length + 1);
            this.indices[this.indices.length - 1] = index;
            this.positions[this.positions.length - 1] = new HashMap<Object, Positions>();
            return this;
        }

        @Override
        public ThreadData.SharedMap acquireRandom() {
            if (this.currentSize == 0) {
                return null;
            }
            return this.acquireAt(ThreadLocalRandom.current().nextInt(this.currentSize));
        }

        @Override
        public ThreadData.SharedMap acquireRandom(Object matchKey, Object value) {
            Positions ps = null;
            for (int i = 0; i < this.indices.length; ++i) {
                if (!this.indices[i].equals(matchKey) || (ps = this.positions[i].get(value)) != null) continue;
                return null;
            }
            assert (ps != null) : "No index for " + matchKey;
            int mainIndex = ps.array[ThreadLocalRandom.current().nextInt(ps.size)];
            return this.acquireAt(mainIndex);
        }

        private ThreadData.SharedMap acquireAt(int mainIndex) {
            MapImpl map = this.maps[mainIndex];
            assert (map.indexLocations.length == this.indices.length);
            for (int i = 0; i < this.indices.length; ++i) {
                int ps2index;
                Object indexKey = this.indices[i];
                Object value2 = map.get(indexKey);
                if (value2 == null) continue;
                Positions ps2 = this.positions[i].get(value2);
                int mainIndexUpdated = ps2.moveLastTo(ps2index = map.indexLocations[i]);
                if (mainIndexUpdated >= 0) {
                    this.maps[mainIndexUpdated].indexLocations[i] = ps2index;
                    continue;
                }
                this.positions[i].remove(value2);
                this.releasePositions(ps2);
            }
            --this.currentSize;
            if (mainIndex != this.currentSize) {
                MapImpl relocated = this.maps[mainIndex] = this.maps[this.currentSize];
                assert (relocated != null);
                for (int i = 0; i < this.indices.length; ++i) {
                    Object indexKey = this.indices[i];
                    Object value3 = relocated.get(indexKey);
                    if (value3 == null) continue;
                    Positions ps3 = this.positions[i].get(value3);
                    ps3.array[relocated.indexLocations[i]] = mainIndex;
                }
            } else {
                this.maps[mainIndex] = null;
            }
            return map;
        }

        @Override
        public int insert(ThreadData.SharedMap map) {
            MapImpl impl = (MapImpl)map;
            int mainIndex = super.insert(map);
            for (int i = 0; i < this.indices.length; ++i) {
                Object value = map.get(this.indices[i]);
                impl.indexLocations[i] = this.positions[i].computeIfAbsent(value, this.acquirePosition).insert(mainIndex);
            }
            return mainIndex;
        }

        private void releasePositions(Positions ps) {
            if (this.unusedPositionsSize == this.unusedPositions.length) {
                this.unusedPositions = Arrays.copyOf(this.unusedPositions, this.unusedPositions.length * 2);
            }
            this.unusedPositions[this.unusedPositionsSize++] = ps;
        }

        private Positions acquirePosition() {
            if (this.unusedPositionsSize == 0) {
                return new Positions();
            }
            return this.unusedPositions[--this.unusedPositionsSize];
        }
    }

    private static class Positions {
        private int[] array = new int[16];
        private int size;

        private Positions() {
        }

        int insert(int target) {
            if (this.size == this.array.length) {
                this.array = Arrays.copyOf(this.array, this.array.length * 2);
            }
            int pos = this.size++;
            this.array[pos] = target;
            return pos;
        }

        int moveLastTo(int pos) {
            assert (this.size != 0);
            --this.size;
            if (this.size == 0) {
                return -1;
            }
            this.array[pos] = this.array[this.size];
            return this.array[pos];
        }
    }

    private static class SharedMapSet {
        MapImpl[] unused;
        int unusedSize;
        int maxEntries;
        MapImpl[] maps;
        int currentSize;

        SharedMapSet(int entries) {
            this.unused = new MapImpl[16];
            this.maps = new MapImpl[16];
            this.maxEntries = entries;
        }

        SharedMapSet(SharedMapSet set, int entries) {
            assert (set.currentSize == 0);
            assert (set.unusedSize == 0);
            this.unused = set.unused;
            this.maps = set.maps;
            this.maxEntries = Math.max(set.maxEntries, entries);
        }

        void ensureEntries(int entries) {
            if (entries > this.maxEntries) {
                assert (this.unusedSize == 0);
                this.maxEntries = entries;
            }
        }

        ThreadData.SharedMap newMap() {
            if (this.unusedSize == 0) {
                return new MapImpl(this.maxEntries, this.numIndices());
            }
            MapImpl last = this.unused[--this.unusedSize];
            this.unused[this.unusedSize] = null;
            return last;
        }

        protected int numIndices() {
            return 0;
        }

        private MapImpl acquireLast() {
            if (this.currentSize <= 0) {
                return null;
            }
            int pos = --this.currentSize;
            MapImpl map = this.maps[pos];
            this.maps[pos] = null;
            return map;
        }

        public ThreadData.SharedMap acquireRandom(Object matchKey, Object value) {
            throw new UnsupportedOperationException("Cannot match " + matchKey + ": not indexed");
        }

        public ThreadData.SharedMap acquireRandom() {
            if (this.currentSize == 0) {
                return null;
            }
            int pos = ThreadLocalRandom.current().nextInt(this.currentSize);
            if (pos == this.currentSize - 1) {
                return this.acquireLast();
            }
            MapImpl map = this.maps[pos];
            this.maps[pos] = this.acquireLast();
            return map;
        }

        public int insert(ThreadData.SharedMap map) {
            if (this.currentSize == this.maps.length) {
                this.maps = Arrays.copyOf(this.maps, this.maps.length * 2);
            }
            int mainIndex = this.currentSize++;
            assert (this.maps[mainIndex] == null);
            this.maps[mainIndex] = (MapImpl)map;
            return mainIndex;
        }

        public void release(ThreadData.SharedMap map) {
            if (this.unusedSize == this.unused.length) {
                this.unused = Arrays.copyOf(this.unused, this.unused.length * 2);
            }
            this.unused[this.unusedSize++] = (MapImpl)map;
        }
    }
}

