/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.config.StepBuilder;
import io.hyperfoil.api.session.Session;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BreakIfFinishedStep
implements Step {
    private static final Logger log = LogManager.getLogger(BreakIfFinishedStep.class);

    public boolean invoke(Session session) {
        if (session.phase().status().isFinished()) {
            log.trace("#{} interrupting sequence {} as {} is finished ({})", (Object)session.uniqueId(), (Object)session.currentSequence(), (Object)session.phase().definition().name(), (Object)session.phase().status());
            session.currentSequence().breakSequence(session);
        }
        return true;
    }

    @Name(value="breakIfFinished")
    public static class Builder
    implements StepBuilder<Builder> {
        public List<Step> build() {
            return Collections.singletonList(new BreakIfFinishedStep());
        }
    }
}

