/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Embed;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.Condition;
import io.hyperfoil.core.builders.DependencyStepBuilder;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.core.steps.DependencyStep;
import io.hyperfoil.function.SerializablePredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BreakSequenceStep
extends DependencyStep {
    private final SerializablePredicate<Session> condition;
    private final Action[] onBreak;

    public BreakSequenceStep(ReadAccess[] dependencies, SerializablePredicate<Session> condition, Action[] onBreak) {
        super(dependencies);
        this.condition = condition;
        this.onBreak = onBreak;
    }

    @Override
    public boolean invoke(Session session) {
        if (!super.invoke(session)) {
            return false;
        }
        if (this.condition.test((Object)session)) {
            if (this.onBreak != null) {
                for (Action a : this.onBreak) {
                    a.run(session);
                }
            }
            session.currentSequence().breakSequence(session);
        }
        return true;
    }

    @Name(value="breakSequence")
    public static class Builder
    extends DependencyStepBuilder<Builder> {
        private final List<Action.Builder> onBreak = new ArrayList<Action.Builder>();
        private Condition.TypesBuilder<Builder> condition = new Condition.TypesBuilder<Builder>(this);

        @Embed
        public Condition.TypesBuilder<Builder> condition() {
            return this.condition;
        }

        public Builder onBreak(Action onBreak) {
            return this.onBreak(() -> onBreak);
        }

        public Builder onBreak(Action.Builder onBreak) {
            this.onBreak.add(onBreak);
            return this;
        }

        public ServiceLoadedBuilderProvider<Action.Builder> onBreak() {
            return new ServiceLoadedBuilderProvider<Action.Builder>(Action.Builder.class, this::onBreak);
        }

        public List<Step> build() {
            Condition condition = this.condition.buildCondition();
            if (condition == null) {
                throw new BenchmarkDefinitionException("In breakSequence step the condition must be defined.");
            }
            Action[] onBreak = this.onBreak.isEmpty() ? null : (Action[])this.onBreak.stream().map(Action.Builder::build).toArray(Action[]::new);
            return Collections.singletonList(new BreakSequenceStep(this.dependencies(), condition, onBreak));
        }
    }
}

