/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DependencyStep
implements Step {
    private static final Logger log = LogManager.getLogger(Step.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ReadAccess[] dependencies;

    protected DependencyStep(ReadAccess[] dependencies) {
        this.dependencies = dependencies;
    }

    public boolean invoke(Session session) {
        if (this.dependencies != null) {
            for (ReadAccess ref : this.dependencies) {
                if (ref.isSet(session)) continue;
                if (trace) {
                    log.trace("Sequence is blocked by missing var reference {}", (Object)ref);
                }
                return false;
            }
        }
        return true;
    }
}

