/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.config.StepBuilder;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.IntAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.steps.SetIntAction;
import io.hyperfoil.function.SerializableToIntFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LoopStep
implements Step {
    private final IntAccess counterVar;
    private final int repeats;

    public LoopStep(IntAccess counterVar, int repeats) {
        this.counterVar = counterVar;
        this.repeats = repeats;
    }

    public boolean invoke(Session session) {
        int value = 1 + this.counterVar.addToInt(session, 1);
        if (value < this.repeats) {
            session.currentSequence().restart(session);
        }
        return true;
    }

    public static class LoopSequenceBuilder
    extends BaseSequenceBuilder<LoopSequenceBuilder> {
        public LoopSequenceBuilder(BaseSequenceBuilder<?> parent) {
            super(Objects.requireNonNull(parent));
        }
    }

    @Name(value="loop")
    public static class Builder
    implements StepBuilder<Builder> {
        private String counterVar;
        private int repeats;
        private final LoopSequenceBuilder steps;

        public Builder() {
            throw new UnsupportedOperationException();
        }

        public Builder(BaseSequenceBuilder<?> parent) {
            this.steps = new LoopSequenceBuilder(parent);
        }

        public Builder counterVar(String counterVar) {
            this.counterVar = counterVar;
            return this;
        }

        public Builder repeats(int repeats) {
            this.repeats = repeats;
            return this;
        }

        @Deprecated
        public Builder sequence(String sequence) {
            throw new BenchmarkDefinitionException("Sequence is not supported anymore; place loop as the first step in a sequence.");
        }

        public LoopSequenceBuilder steps() {
            return this.steps;
        }

        public List<Step> build() {
            Locator locator = Locator.current();
            if (locator.sequence().indexOf((StepBuilder)this) != 0) {
                throw new BenchmarkDefinitionException("Loop step must be placed as the first step in a sequence.");
            }
            if (this.counterVar == null) {
                throw new BenchmarkDefinitionException("loop.counterVar must be set.");
            }
            if (this.repeats <= 0) {
                throw new BenchmarkDefinitionException("loop.repeats must be > 0");
            }
            if (this.steps.isEmpty()) {
                throw new BenchmarkDefinitionException("The loop does not include any steps. Cannot construct empty loop.");
            }
            IntAccess counter = SessionFactory.intAccess(this.counterVar);
            if (locator.sequence().rootSequence().concurrency() > 0 && !counter.isSequenceScoped()) {
                throw new BenchmarkDefinitionException("In concurrent sequences the counter var should be sequence-scoped.");
            }
            ArrayList<Step> allSteps = new ArrayList<Step>();
            allSteps.add((Step)new StepBuilder.ActionStep((Action)new SetIntAction(counter, (SerializableToIntFunction<Session>)(SerializableToIntFunction & Serializable)session -> 0, true, null)));
            allSteps.addAll(this.steps.buildSteps());
            allSteps.add(new LoopStep(counter, this.repeats));
            return allSteps;
        }
    }
}

