/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps.collections;

import io.hyperfoil.api.config.Embed;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.ObjectSourceBuilder;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddItemAction
implements Action {
    private static final Logger log = LogManager.getLogger(AddItemAction.class);
    private final SerializableFunction<Session, Object> item;
    private final ReadAccess toVar;

    public AddItemAction(SerializableFunction<Session, Object> item, ReadAccess toVar) {
        this.item = item;
        this.toVar = toVar;
    }

    public void run(Session session) {
        ObjectVar[] array;
        if (!this.toVar.isSet(session)) {
            throw new IllegalStateException("Destination variable " + this.toVar + " is not set (should contain array)");
        }
        Object item = this.item.apply((Object)session);
        Object dest = this.toVar.getObject(session);
        if (dest instanceof ObjectVar[]) {
            array = (ObjectVar[])dest;
            for (int i = 0; i < array.length; ++i) {
                if (array[i].isSet()) continue;
                array[i].set(item);
                return;
            }
        } else {
            throw new IllegalStateException("Variable " + this.toVar + " should contain ObjectVar array but it contains " + dest);
        }
        log.warn("#{} The array in variable {} is full ({} items), cannot add {}", (Object)session.uniqueId(), (Object)this.toVar, (Object)array.length, item);
    }

    @Name(value="addItem")
    public static class Builder
    implements Action.Builder {
        private String toVar;
        @Embed
        public ObjectSourceBuilder<Builder> item = new ObjectSourceBuilder<Builder>(this);

        public Builder toVar(String toVar) {
            this.toVar = toVar;
            return this;
        }

        public AddItemAction build() {
            return new AddItemAction(this.item.build(), SessionFactory.readAccess(this.toVar));
        }
    }
}

