/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps.collections;

import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.IntAccess;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.ObjectSourceBuilder;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableFunction;
import java.util.List;
import java.util.Objects;

public class GetIndexAction
implements Action {
    private final ReadAccess collection;
    private final SerializableFunction<Session, Object> item;
    private final IntAccess toVar;

    public GetIndexAction(ReadAccess collection, SerializableFunction<Session, Object> item, IntAccess toVar) {
        this.collection = collection;
        this.item = item;
        this.toVar = toVar;
    }

    public void run(Session session) {
        Object collection = this.collection.getObject(session);
        Object item = this.item.apply((Object)session);
        if (collection instanceof ObjectVar[]) {
            ObjectVar[] vars = (ObjectVar[])collection;
            for (int i = 0; i < vars.length && vars[i].isSet(); ++i) {
                if (!Objects.equals(item, vars[i].objectValue(session))) continue;
                this.toVar.setInt(session, i);
                return;
            }
            this.toVar.setInt(session, -1);
        } else if (collection instanceof Object[]) {
            Object[] items = (Object[])collection;
            for (int i = 0; i < items.length; ++i) {
                if (!Objects.equals(item, items[i])) continue;
                this.toVar.setInt(session, i);
                return;
            }
        } else if (collection instanceof List) {
            List list = (List)collection;
            for (int i = 0; i < list.size(); ++i) {
                if (!Objects.equals(item, list.get(i))) continue;
                this.toVar.setInt(session, i);
                return;
            }
        } else {
            throw new IllegalArgumentException("Cannot lookup " + item + " in " + collection + ": unsupported collection type.");
        }
    }

    @Name(value="getIndex")
    public static class Builder
    implements Action.Builder {
        private String collection;
        private ObjectSourceBuilder<Builder> item = new ObjectSourceBuilder<Builder>(this);
        private String toVar;

        public Builder collection(String collection) {
            this.collection = collection;
            return this;
        }

        public ObjectSourceBuilder<Builder> item() {
            return this.item;
        }

        public Builder toVar(String toVar) {
            this.toVar = toVar;
            return this;
        }

        public GetIndexAction build() {
            return new GetIndexAction(SessionFactory.readAccess(this.collection), this.item.build(), SessionFactory.intAccess(this.toVar));
        }
    }
}

