/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps.collections;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.IntAccess;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.steps.collections.BoolFilter;
import io.hyperfoil.core.steps.collections.IntFilter;
import io.hyperfoil.core.steps.collections.StringFilter;
import java.lang.reflect.Array;
import java.util.Collection;

public class GetSizeAction
implements Action {
    private final ReadAccess fromVar;
    private final IntAccess toVar;
    private final int undefinedValue;
    private final BoolFilter boolFilter;
    private final StringFilter stringFilter;
    private final IntFilter intFilter;

    public GetSizeAction(ReadAccess fromVar, IntAccess toVar, int undefinedValue, BoolFilter boolFilter, StringFilter stringFilter, IntFilter intFilter) {
        this.fromVar = fromVar;
        this.toVar = toVar;
        this.undefinedValue = undefinedValue;
        this.boolFilter = boolFilter;
        this.stringFilter = stringFilter;
        this.intFilter = intFilter;
    }

    public void run(Session session) {
        if (!this.fromVar.isSet(session)) {
            this.toVar.setInt(session, this.undefinedValue);
            return;
        }
        Object obj = this.fromVar.getObject(session);
        if (obj == null) {
            this.toVar.setInt(session, this.undefinedValue);
        } else if (obj.getClass().isArray()) {
            if (Session.Var.class.isAssignableFrom(obj.getClass().getComponentType())) {
                Session.Var[] vars = (Session.Var[])obj;
                int size = 0;
                for (int i = 0; i < vars.length && vars[i].isSet(); ++i) {
                    if (!this.testVar(session, vars[i])) continue;
                    ++size;
                }
                this.toVar.setInt(session, size);
            } else {
                int length = Array.getLength(obj);
                if (this.boolFilter == null && this.stringFilter == null && this.intFilter == null) {
                    this.toVar.setInt(session, length);
                } else {
                    int size = 0;
                    for (int i = 0; i < length; ++i) {
                        if (!this.testItem(session, Array.get(obj, i))) continue;
                        ++size;
                    }
                    this.toVar.setInt(session, size);
                }
            }
        } else if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            int length = collection.size();
            if (this.boolFilter == null && this.stringFilter == null && this.intFilter == null) {
                this.toVar.setInt(session, length);
            } else {
                int size = 0;
                for (Object item : collection) {
                    if (!this.testItem(session, item)) continue;
                    ++size;
                }
                this.toVar.setInt(session, size);
            }
        } else {
            this.toVar.setInt(session, this.undefinedValue);
        }
    }

    private boolean testVar(Session session, Session.Var var) {
        return !(this.boolFilter != null && !this.boolFilter.testVar(session, var) || this.stringFilter != null && !this.stringFilter.testVar(session, var) || this.intFilter != null && !this.intFilter.testVar(session, var));
    }

    private boolean testItem(Session session, Object item) {
        return !(this.boolFilter != null && !this.boolFilter.testObject(item) || this.stringFilter != null && !this.stringFilter.testObject(session, item) || this.intFilter != null && !this.intFilter.testObject(session, item));
    }

    @Name(value="getSize")
    public static class Builder
    implements Action.Builder {
        private String fromVar;
        private String toVar;
        private int undefinedValue = -1;
        private BoolFilter.Builder<Builder> boolFilter;
        private StringFilter.Builder<Builder> stringFilter;
        private IntFilter.Builder<Builder> intFilter;

        public Builder fromVar(String fromVar) {
            this.fromVar = fromVar;
            return this;
        }

        public Builder toVar(String toVar) {
            this.toVar = toVar;
            return this;
        }

        public BoolFilter.Builder<Builder> boolFilter() {
            if (this.boolFilter != null) {
                throw new BenchmarkDefinitionException("Bool filter already set!");
            }
            this.boolFilter = new BoolFilter.Builder<Builder>(this);
            return this.boolFilter;
        }

        public StringFilter.Builder<Builder> stringFilter() {
            if (this.stringFilter != null) {
                throw new BenchmarkDefinitionException("String filter already set!");
            }
            this.stringFilter = new StringFilter.Builder<Builder>(this);
            return this.stringFilter;
        }

        public IntFilter.Builder<Builder> intFilter() {
            if (this.intFilter != null) {
                throw new BenchmarkDefinitionException("Integer filter already set!");
            }
            this.intFilter = new IntFilter.Builder<Builder>(this);
            return this.intFilter;
        }

        public Builder undefinedValue(int undefinedValue) {
            this.undefinedValue = undefinedValue;
            return this;
        }

        public GetSizeAction build() {
            return new GetSizeAction(SessionFactory.readAccess(this.fromVar), SessionFactory.intAccess(this.toVar), this.undefinedValue, this.boolFilter == null ? null : this.boolFilter.build(), this.stringFilter == null ? null : this.stringFilter.build(), this.intFilter == null ? null : this.intFilter.build());
        }
    }
}

