/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps.data;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.IntAccess;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.ThreadData;
import io.hyperfoil.core.session.SessionFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetSharedCounterAction
implements Action,
ResourceUtilizer {
    private static final Logger log = LogManager.getLogger(GetSharedCounterAction.class);
    private final String key;
    private final IntAccess toVar;

    public GetSharedCounterAction(String key, IntAccess toVar) {
        this.key = key;
        this.toVar = toVar;
    }

    public void run(Session session) {
        ThreadData.SharedCounter counter = session.threadData().getCounter(this.key);
        if (counter.get() > Integer.MAX_VALUE) {
            log.warn("Shared counter value ({}) exceeds maximum integer; capping to {}", (Object)counter.get(), (Object)Integer.MAX_VALUE);
            this.toVar.setInt(session, Integer.MAX_VALUE);
        } else if (counter.get() < Integer.MIN_VALUE) {
            log.warn("Shared counter value ({}) exceeds minimum integer; capping to {}", (Object)counter.get(), (Object)Integer.MIN_VALUE);
            this.toVar.setInt(session, Integer.MIN_VALUE);
        } else {
            this.toVar.setInt(session, (int)counter.get());
        }
    }

    public void reserve(Session session) {
        session.threadData().reserveCounter(this.key);
    }

    @Name(value="getSharedCounter")
    public static class Builder
    implements Action.Builder,
    InitFromParam<Builder> {
        private String key;
        private String toVar;

        public Builder init(String param) {
            return this.key(param).toVar(param);
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder toVar(String toVar) {
            this.toVar = toVar;
            return this;
        }

        public GetSharedCounterAction build() {
            if (this.key == null || this.key.isEmpty()) {
                throw new BenchmarkDefinitionException("Invalid key: " + this.key);
            }
            if (this.toVar == null) {
                throw new BenchmarkDefinitionException("Must set 'toVar'");
            }
            return new GetSharedCounterAction(this.key, SessionFactory.intAccess(this.toVar));
        }
    }
}

