/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps.data;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.ListBuilder;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.PairBuilder;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.GlobalData;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.data.GlobalCounters;
import io.hyperfoil.core.session.SessionFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PublishGlobalCountersAction
implements Action {
    private static final Logger log = LogManager.getLogger(PublishGlobalCountersAction.class);
    private final String key;
    private final String[] names;
    private final ReadAccess[] vars;

    public PublishGlobalCountersAction(String key, String[] names, ReadAccess[] vars) {
        assert (names.length == vars.length);
        this.key = key;
        this.names = names;
        this.vars = vars;
    }

    public void run(Session session) {
        HashMap<String, Long> counters = new HashMap<String, Long>();
        block6: for (int i = 0; i < this.names.length; ++i) {
            Session.Var var = this.vars[i].getVar(session);
            switch (var.type()) {
                case OBJECT: {
                    Object obj = var.objectValue(session);
                    if (obj instanceof String) {
                        try {
                            long value = Long.parseLong((String)obj);
                            counters.put(this.names[i], value);
                        }
                        catch (NumberFormatException e) {
                            log.warn("#{}: Cannot parse {} obj into long value", (Object)session.uniqueId(), obj);
                        }
                        continue block6;
                    }
                    log.warn("#{}: Cannot parse {} obj into long value", (Object)session.uniqueId(), obj);
                    continue block6;
                }
                case INTEGER: {
                    counters.put(this.names[i], Long.valueOf(var.intValue(session)));
                }
            }
        }
        session.globalData().publish(session.phase().definition().name(), this.key, (GlobalData.Element)new GlobalCounters(counters));
    }

    @Name(value="publishGlobalCounters")
    public static class Builder
    implements Action.Builder {
        private String key;
        private List<String> names = new ArrayList<String>();
        private List<String> vars = new ArrayList<String>();

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public VarsBuilder vars() {
            return new VarsBuilder();
        }

        public Action build() {
            if (this.key == null || this.key.isEmpty()) {
                throw new BenchmarkDefinitionException("Invalid key: " + this.key);
            }
            if (this.names.isEmpty() || this.vars.isEmpty()) {
                throw new BenchmarkDefinitionException("No counters!");
            }
            return new PublishGlobalCountersAction(this.key, this.names.toArray(new String[0]), (ReadAccess[])this.vars.stream().map(SessionFactory::readAccess).toArray(ReadAccess[]::new));
        }

        public class VarsBuilder
        extends PairBuilder.OfString
        implements ListBuilder {
            public void nextItem(String key) {
                Builder.this.names.add(key);
                Builder.this.vars.add(key);
            }

            public void accept(String name, String var) {
                Builder.this.names.add(name);
                Builder.this.vars.add(var);
            }
        }
    }
}

