/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps.data;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.ListBuilder;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.ThreadData;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.steps.data.SharedDataHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PushSharedMapStep
implements Step,
ResourceUtilizer {
    private final String key;
    private final ObjectAccess[] vars;

    public PushSharedMapStep(String key, ObjectAccess[] vars) {
        this.key = key;
        this.vars = vars;
    }

    public boolean invoke(Session session) {
        ThreadData threadData = session.threadData();
        ThreadData.SharedMap sharedMap = threadData.newMap(this.key);
        for (int i = 0; i < this.vars.length; ++i) {
            Object value = this.vars[i].getObject(session);
            value = SharedDataHelper.unwrapVars(session, value);
            sharedMap.put(this.vars[i].key(), value);
        }
        threadData.pushMap(this.key, sharedMap);
        return true;
    }

    public void reserve(Session session) {
        session.threadData().reserveMap(this.key, null, this.vars.length);
    }

    @Name(value="pushSharedMap")
    public static class Builder
    extends BaseStepBuilder<Builder> {
        private String key;
        private Collection<String> vars = new ArrayList<String>();

        public List<Step> build() {
            if (this.key == null || this.key.isEmpty()) {
                throw new BenchmarkDefinitionException("Invalid key: " + this.key);
            }
            if (this.vars.isEmpty()) {
                throw new BenchmarkDefinitionException("No variables pushed for key " + this.key);
            }
            ObjectAccess[] accesses = (ObjectAccess[])this.vars.stream().map(SessionFactory::objectAccess).toArray(ObjectAccess[]::new);
            return Collections.singletonList(new PushSharedMapStep(this.key, accesses));
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public ListBuilder vars() {
            return this.vars::add;
        }
    }
}

