/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps.data;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Embed;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.ThreadData;
import io.hyperfoil.core.builders.IntSourceBuilder;
import io.hyperfoil.function.SerializableToIntFunction;

public class SetSharedCounterAction
implements Action,
ResourceUtilizer {
    private final String key;
    private final SerializableToIntFunction<Session> input;

    public SetSharedCounterAction(String key, SerializableToIntFunction<Session> input) {
        this.key = key;
        this.input = input;
    }

    public void run(Session session) {
        ThreadData.SharedCounter counter = session.threadData().getCounter(this.key);
        counter.set((long)this.input.applyAsInt((Object)session));
    }

    public void reserve(Session session) {
        session.threadData().reserveCounter(this.key);
    }

    @Name(value="setSharedCounter")
    public static class Builder
    implements Action.Builder,
    InitFromParam<Builder> {
        private String key;
        @Embed
        public IntSourceBuilder<Builder> input = new IntSourceBuilder<Builder>(this);

        public Builder init(String param) {
            return this.key((String)param).input.fromVar(param).end();
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public SetSharedCounterAction build() {
            if (this.key == null || this.key.isEmpty()) {
                throw new BenchmarkDefinitionException("Invalid key: " + this.key);
            }
            return new SetSharedCounterAction(this.key, this.input.build());
        }
    }
}

