/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.util;

import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.function.SerializableBiFunction;
import io.hyperfoil.impl.Util;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FromVarBytesGenerator
implements SerializableBiFunction<Session, Connection, ByteBuf> {
    private static final Logger log = LogManager.getLogger(FromVarBytesGenerator.class);
    private final ReadAccess fromVar;

    public FromVarBytesGenerator(ReadAccess fromVar) {
        this.fromVar = fromVar;
    }

    public ByteBuf apply(Session session, Connection connection) {
        Object value = this.fromVar.getObject(session);
        if (value instanceof ByteBuf) {
            return (ByteBuf)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            return Util.string2byteBuf((CharSequence)str, (ByteBuf)connection.context().alloc().buffer(str.length()));
        }
        if (value instanceof byte[]) {
            return Unpooled.wrappedBuffer((byte[])((byte[])value));
        }
        log.error("#{} Cannot encode contents of var {}: {}", (Object)session.uniqueId(), (Object)this.fromVar, value);
        return null;
    }
}

