/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli;

import io.hyperfoil.core.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Stream;
import org.aesh.terminal.utils.ANSI;

public class Table<T> {
    private boolean boldHeader = true;
    private Function<T, String> rowPrefix;
    private Function<T, String> rowSuffix;
    private final List<String> titles = new ArrayList<String>();
    private final List<Function<T, String>> functions = new ArrayList<Function<T, String>>();
    private final List<Align> aligns = new ArrayList<Align>();

    public Table<T> boldHeader(boolean boldHeader) {
        this.boldHeader = boldHeader;
        return this;
    }

    public Table<T> rowPrefix(Function<T, String> rowPrefix) {
        if (this.rowPrefix != null) {
            throw new IllegalStateException("Row prefix already set.");
        }
        this.rowPrefix = rowPrefix;
        return this;
    }

    public Table<T> rowSuffix(Function<T, String> rowSuffix) {
        if (this.rowSuffix != null) {
            throw new IllegalStateException("Row suffix already set.");
        }
        this.rowSuffix = rowSuffix;
        return this;
    }

    public Table<T> column(String title, Function<T, String> func) {
        return this.column(title, func, Align.LEFT);
    }

    public Table<T> columnInt(String title, Function<T, Integer> func) {
        return this.column(title, value -> String.valueOf(func.apply(value)), Align.RIGHT);
    }

    public Table<T> columnLong(String title, Function<T, Long> func) {
        return this.column(title, value -> String.valueOf(func.apply(value)), Align.RIGHT);
    }

    public Table<T> columnNanos(String title, Function<T, Long> func) {
        return this.column(title, value -> Util.prettyPrintNanos((long)((Long)func.apply(value))), Align.RIGHT);
    }

    public Table<T> column(String title, Function<T, String> func, Align align) {
        this.titles.add(title);
        this.functions.add(func);
        this.aligns.add(align);
        return this;
    }

    public String print(String keyTitle, Map<String, Stream<T>> map) {
        ArrayList<String> titles = new ArrayList<String>();
        titles.add(keyTitle);
        titles.addAll(this.titles);
        ArrayList<Align> aligns = new ArrayList<Align>();
        aligns.add(Align.LEFT);
        aligns.addAll(this.aligns);
        ArrayList<String> prefixes = this.rowPrefix == null ? null : new ArrayList<String>();
        ArrayList<String> suffixes = this.rowSuffix == null ? null : new ArrayList<String>();
        ArrayList<String[]> values = new ArrayList<String[]>();
        int[] width = titles.stream().mapToInt(Table::width).toArray();
        map.forEach((key, value) -> {
            AtomicBoolean first = new AtomicBoolean(true);
            value.forEach(item -> {
                if (this.rowPrefix != null) {
                    prefixes.add(this.rowPrefix.apply(item));
                }
                if (this.rowSuffix != null) {
                    suffixes.add(this.rowSuffix.apply(item));
                }
                String[] row = new String[this.functions.size() + 1];
                row[0] = first.compareAndSet(true, false) ? key : "";
                width[0] = Math.max(width[0], Table.width(key));
                for (int i = 1; i < row.length; ++i) {
                    row[i] = this.functions.get(i - 1).apply(item);
                    if (row[i] == null) {
                        row[i] = "";
                    }
                    width[i] = Math.max(width[i], Table.width(row[i]));
                }
                values.add(row);
            });
        });
        return this.print(titles, prefixes, values, suffixes, aligns, width);
    }

    public String print(Stream<T> stream) {
        ArrayList<String[]> values = new ArrayList<String[]>();
        ArrayList<String> prefixes = this.rowPrefix == null ? null : new ArrayList<String>();
        ArrayList<String> suffixes = this.rowSuffix == null ? null : new ArrayList<String>();
        int[] width = this.titles.stream().mapToInt(Table::width).toArray();
        stream.forEach(item -> {
            if (this.rowPrefix != null) {
                prefixes.add(this.rowPrefix.apply(item));
            }
            if (this.rowSuffix != null) {
                suffixes.add(this.rowSuffix.apply(item));
            }
            String[] row = new String[this.functions.size()];
            for (int i = 0; i < row.length; ++i) {
                row[i] = this.functions.get(i).apply(item);
                if (row[i] == null) {
                    row[i] = "";
                }
                width[i] = Math.max(width[i], Table.width(row[i]));
            }
            values.add(row);
        });
        return this.print(this.titles, prefixes, values, suffixes, this.aligns, width);
    }

    private static int width(String str) {
        int width = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\u001b') {
                char c;
                ++i;
                while (!(i >= str.length() || (c = str.charAt(i)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    ++i;
                }
                continue;
            }
            ++width;
        }
        return width;
    }

    private String print(List<String> titles, List<String> prefixes, List<String[]> values, List<String> suffixes, List<Align> aligns, int[] width) {
        StringBuilder sb = new StringBuilder();
        if (this.boldHeader) {
            sb.append(ANSI.BOLD);
        }
        for (int i = 0; i < titles.size() - 1; ++i) {
            String title = titles.get(i);
            sb.append(title);
            Table.pad(sb, width[i] - Table.width(title) + 2);
        }
        sb.append(titles.get(titles.size() - 1));
        if (this.boldHeader) {
            sb.append("\u001b[0m");
        }
        sb.append('\n');
        int prefixLength = prefixes == null ? 0 : prefixes.stream().filter(Objects::nonNull).mapToInt(Table::width).max().orElse(0);
        int suffixLength = prefixes == null ? 0 : prefixes.stream().filter(Objects::nonNull).mapToInt(Table::width).max().orElse(0);
        int rowNumber = 0;
        for (String[] row : values) {
            String suffix;
            String prefix;
            String string = prefix = prefixes == null ? null : prefixes.get(rowNumber);
            if (prefix != null) {
                sb.append(prefix);
                Table.pad(sb, prefixLength - Table.width(prefix));
            }
            for (int i = 0; i < row.length; ++i) {
                Align align = aligns.get(i);
                if (align == Align.RIGHT) {
                    Table.pad(sb, width[i] - Table.width(row[i]));
                }
                sb.append(row[i]);
                if (align == Align.LEFT) {
                    Table.pad(sb, width[i] - Table.width(row[i]));
                }
                sb.append("  ");
            }
            String string2 = suffix = suffixes == null ? null : suffixes.get(rowNumber);
            if (suffix != null) {
                sb.append(suffix);
                Table.pad(sb, suffixLength - Table.width(suffix));
            }
            sb.append('\n');
            ++rowNumber;
        }
        return sb.toString();
    }

    private static void pad(StringBuilder sb, int n) {
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
    }

    public static enum Align {
        LEFT,
        RIGHT;

    }
}

