/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.BaseRunIdCommand;
import io.hyperfoil.cli.context.HyperfoilCliContext;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.aesh.command.CommandException;
import org.aesh.command.option.Option;

public abstract class BaseReportCommand
extends BaseRunIdCommand {
    private static final String TEMPLATE_URL = "https://hyperfoil.io/report-template.html";
    @Option(shortName=115, description="Other file (in given run) to use as report input.")
    private String source;

    protected String getReport(HyperfoilCommandInvocation invocation) throws CommandException {
        String json;
        String template = null;
        File templateCache = new File("./.report-template.html.cached");
        if (templateCache.exists() && templateCache.isFile()) {
            try {
                template = Files.readString(templateCache.toPath());
            }
            catch (IOException e) {
                throw new CommandException("Cannot read cached report template: ", (Throwable)e);
            }
        }
        if (template == null) {
            template = this.fetchTemplate(invocation);
            try {
                Files.write(templateCache.toPath(), template.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new CommandException("Cannot store cached report template: ", (Throwable)e);
            }
        }
        Client.RunRef runRef = this.getRunRef(invocation);
        if (this.source == null || this.source.isEmpty()) {
            try {
                byte[] bytes = runRef.statsAll("application/json");
                json = new String(bytes, StandardCharsets.UTF_8);
            }
            catch (RestClientException e) {
                throw new CommandException("Failed to download statistics: ", (Throwable)e);
            }
        }
        try {
            json = new String(runRef.file(this.source), StandardCharsets.UTF_8);
        }
        catch (RestClientException e) {
            throw new CommandException("Failed to download file '" + this.source + "': ", (Throwable)e);
        }
        return template.replace("[/**DATAKEY**/]", json);
    }

    private String fetchTemplate(HyperfoilCommandInvocation invocation) throws CommandException {
        HyperfoilCliContext ctx = invocation.context();
        try (WebClient client = WebClient.create((Vertx)ctx.vertx(), (WebClientOptions)new WebClientOptions().setFollowRedirects(true));){
            HttpRequest request = client.requestAbs(HttpMethod.GET, TEMPLATE_URL);
            CompletableFuture future = new CompletableFuture();
            ctx.vertx().runOnContext(nil -> request.send(result -> {
                if (result.succeeded()) {
                    future.complete(((HttpResponse)result.result()).bodyAsString());
                } else {
                    future.completeExceptionally(result.cause());
                }
            }));
            String string = (String)future.get(30L, TimeUnit.SECONDS);
            return string;
        }
    }
}

