/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.RunCompleter;
import io.hyperfoil.cli.commands.ServerCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.controller.Client;
import io.hyperfoil.controller.model.Run;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.aesh.command.CommandException;
import org.aesh.command.option.Argument;

public abstract class BaseRunIdCommand
extends ServerCommand {
    @Argument(description="ID of the run", completer=RunCompleter.class)
    private String runId;

    protected Client.RunRef getRunRef(HyperfoilCommandInvocation invocation) throws CommandException {
        Client.RunRef runRef;
        this.ensureConnection(invocation);
        if (this.runId == null || this.runId.isEmpty()) {
            runRef = invocation.context().serverRun();
            if (runRef == null) {
                invocation.println("Command '" + this.getClass().getSimpleName().toLowerCase() + "' requires run ID as argument! Available runs:");
                List<Run> runs = invocation.context().client().runs(false);
                this.printList(invocation, runs.stream().map(r -> r.id).sorted(Comparator.reverseOrder()).collect(Collectors.toList()), 15);
                throw new CommandException("Cannot run command without run ID.");
            }
        } else {
            runRef = invocation.context().client().run(this.runId);
            invocation.context().setServerRun(runRef);
        }
        return runRef;
    }
}

