/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.cli.CliUtil;
import io.hyperfoil.cli.commands.BaseEditCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import io.hyperfoil.core.parser.BenchmarkParser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.util.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;

@CommandDefinition(name="edit", description="Edit benchmark definition.")
public class Edit
extends BaseEditCommand {
    private static final Path SKIP = Paths.get(".SKIP", new String[0]);
    @Option(name="editor", shortName=101, description="Editor used.")
    private String editor;

    /*
     * Unable to fully structure code
     */
    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        benchmarkRef = this.ensureBenchmark(invocation);
        source = this.ensureSource(invocation, benchmarkRef);
        filesToUpload = new HashMap<String, Path>();
        try {
            sourceFile = File.createTempFile(benchmarkRef.name() + "-", ".yaml");
            Files.write(sourceFile.toPath(), source.source.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new CommandException("Cannot create temporary file for edits.", (Throwable)e);
        }
        modifiedTimestamp = sourceFile.lastModified();
        while (true) lbl-1000:
        // 2 sources

        {
            try {
                CliUtil.execProcess(invocation, true, this.editor == null ? Edit.EDITOR : this.editor, new String[]{sourceFile.getAbsolutePath()});
            }
            catch (IOException e) {
                sourceFile.delete();
                throw new CommandException("Failed to invoke the editor.", (Throwable)e);
            }
            if (sourceFile.lastModified() == modifiedTimestamp) {
                invocation.println("No changes, not uploading.");
                sourceFile.delete();
                return CommandResult.SUCCESS;
            }
            cancelled = new AtomicBoolean(false);
            filesToUpload.clear();
            askingData = new AskingBenchmarkData(invocation, cancelled, filesToUpload);
            try {
                updatedSource = Files.readAllBytes(sourceFile.toPath());
                updated = BenchmarkParser.instance().buildBenchmark((InputStream)new ByteArrayInputStream(updatedSource), (BenchmarkData)askingData);
                break;
            }
            catch (BenchmarkDefinitionException | ParserException e) {
                if (cancelled.get()) {
                    invocation.println("Edits cancelled.");
                    sourceFile.delete();
                    return CommandResult.FAILURE;
                }
                invocation.error(e);
                invocation.println("Retry edits? [Y/n] ");
                try {
                    var12_16 = invocation.inputLine().trim().toLowerCase();
                    var13_18 = -1;
                    switch (var12_16.hashCode()) {
                        case 110: {
                            if (!var12_16.equals("n")) break;
                            var13_18 = 0;
                            break;
                        }
                        case 3521: {
                            if (!var12_16.equals("no")) break;
                            var13_18 = 1;
                        }
                    }
                    switch (var13_18) {
                        case 0: 
                        case 1: {
                            return CommandResult.FAILURE;
                        }
                    }
                    continue;
                }
                catch (InterruptedException ie) {
                    invocation.println("Edits cancelled.");
                    sourceFile.delete();
                    return CommandResult.FAILURE;
                }
            }
            ** while (true)
            catch (IOException e) {
                invocation.error(e);
                throw new CommandException("Failed to load the benchmark.", (Throwable)e);
            }
            break;
        }
        try {
            prevVersion = source.version;
            if (!updated.name().equals(benchmarkRef.name())) {
                invocation.println("NOTE: Renamed benchmark " + benchmarkRef.name() + " to " + updated.name() + "; old benchmark won't be deleted.");
                prevVersion = null;
            }
            invocation.println("Uploading benchmark " + updated.name() + "...");
            filesToUpload.entrySet().removeIf((Predicate<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$execute$0(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Z)());
            invocation.context().client().register(sourceFile.getAbsolutePath(), filesToUpload, prevVersion, benchmarkRef.name());
            sourceFile.delete();
        }
        catch (RestClientException e) {
            if (e.getCause() instanceof Client.EditConflictException) {
                switch (1.$SwitchMap$io$hyperfoil$cli$commands$BaseEditCommand$ConflictResolution[this.askForConflictResolution(invocation).ordinal()]) {
                    case 1: {
                        invocation.println("You can find your edits in " + sourceFile);
                        return CommandResult.SUCCESS;
                    }
                    case 2: {
                        try {
                            invocation.executeCommand("edit " + this.benchmark + (String)(this.editor == null ? "" : " -e " + this.editor));
                        }
                        catch (Exception var10_12) {
                            // empty catch block
                        }
                        return CommandResult.SUCCESS;
                    }
                    case 3: {
                        invocation.context().client().register(updated, null);
                    }
                }
            }
            invocation.println(Util.explainCauses((Throwable)e));
            invocation.println("You can find your edits in " + sourceFile);
            throw new CommandException("Failed to upload the benchmark", (Throwable)e);
        }
        invocation.println("Benchmark " + updated.name() + " updated.");
        return CommandResult.SUCCESS;
    }

    private static /* synthetic */ boolean lambda$execute$0(Map.Entry entry) {
        return entry.getValue() == SKIP;
    }

    private static class AskingBenchmarkData
    implements BenchmarkData {
        private final AtomicBoolean cancelled;
        private final Map<String, Path> filesToUpload;
        private final HyperfoilCommandInvocation invocation;

        public AskingBenchmarkData(HyperfoilCommandInvocation invocation, AtomicBoolean cancelled, Map<String, Path> filesToUpload) {
            this.cancelled = cancelled;
            this.filesToUpload = filesToUpload;
            this.invocation = invocation;
        }

        public InputStream readFile(String file) {
            block14: {
                if (this.cancelled.get() || this.filesToUpload.containsKey(file)) {
                    return BaseEditCommand.EMPTY_INPUT_STREAM;
                }
                File ff = new File(file);
                try {
                    if (ff.exists()) {
                        this.invocation.print("Re-upload file " + file + "? [y/N] ");
                        switch (this.invocation.inputLine().trim().toLowerCase()) {
                            case "y": 
                            case "yes": {
                                this.filesToUpload.put(file, ff.toPath());
                                break;
                            }
                            default: {
                                this.filesToUpload.put(file, SKIP);
                                break;
                            }
                        }
                        break block14;
                    }
                    if (!ff.isAbsolute()) {
                        this.invocation.println("Non-absolute path " + file + ", set absolute path or leave empty to skip: ");
                        while (true) {
                            String path;
                            if ((path = this.invocation.inputLine().trim()).isEmpty()) {
                                this.invocation.println("Ignoring file " + file + ".");
                                break block14;
                            }
                            ff = new File(path);
                            if (ff.exists()) break;
                            this.invocation.println("Invalid path " + path + ", retry or leave empty to skip: ");
                        }
                        this.filesToUpload.put(file, ff.toPath());
                        break block14;
                    }
                    this.invocation.println("Ignoring file " + file + " as it doesn't exist on local file system.");
                }
                catch (InterruptedException ie) {
                    this.cancelled.set(true);
                    throw new BenchmarkDefinitionException("interrupted");
                }
            }
            return BaseEditCommand.EMPTY_INPUT_STREAM;
        }

        public Map<String, byte[]> files() {
            return Collections.emptyMap();
        }
    }
}

