/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.BaseExportCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.controller.Client;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;

@CommandDefinition(name="export", description="Export run statistics.")
public class Export
extends BaseExportCommand {
    @Option(shortName=100, description="Target file/directory for the output", required=true, askIfNotSet=true)
    public Resource destination;
    @Option(shortName=121, description="Assume yes for all interactive questions.", hasValue=false)
    public boolean assumeYes;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException, InterruptedException {
        this.ensureConnection(invocation);
        Client.RunRef runRef = this.getRunRef(invocation);
        String acceptFormat = this.getAcceptFormat();
        String defaultFilename = this.getDefaultFilename(runRef);
        Object destinationFile = this.destination.toString();
        if (this.destination.isDirectory()) {
            destinationFile = this.destination + File.separator + defaultFilename;
        }
        if (this.destination.exists() && !this.assumeYes) {
            invocation.print("File " + (String)destinationFile + " already exists, override? [y/N] ");
            switch (invocation.getShell().readLine().trim().toLowerCase()) {
                case "y": 
                case "yes": {
                    break;
                }
                default: {
                    invocation.println("Export cancelled.");
                    return CommandResult.SUCCESS;
                }
            }
        }
        byte[] bytes = runRef.statsAll(acceptFormat);
        try {
            Files.write(Paths.get((String)destinationFile, new String[0]), bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            invocation.error("Failed to write stats into " + (String)destinationFile);
        }
        return CommandResult.SUCCESS;
    }
}

