/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.BenchmarkCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;

@CommandDefinition(name="inspect", description="Show detailed structure of the benchmark.")
public class Inspect
extends BenchmarkCommand {
    @Option(name="pager", shortName=112, description="Pager used.")
    private String pager;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException, InterruptedException {
        String structure;
        this.ensureConnection(invocation);
        try {
            Client.BenchmarkRef benchmarkRef = this.ensureBenchmark(invocation);
            structure = benchmarkRef.structure();
        }
        catch (RestClientException e) {
            invocation.error(e);
            throw new CommandException("Cannot get benchmark " + this.benchmark);
        }
        invocation.context().createPager(this.pager).open(invocation, structure, this.benchmark + "-structure-", ".yaml");
        return CommandResult.SUCCESS;
    }
}

