/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.BaseRunIdCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import io.hyperfoil.controller.model.Phase;
import io.hyperfoil.controller.model.Run;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;

@CommandDefinition(name="kill", description="Terminate run.")
public class Kill
extends BaseRunIdCommand {
    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException, InterruptedException {
        Client.RunRef runRef = this.getRunRef(invocation);
        Run run = runRef.get();
        invocation.print("Kill run " + run.id + ", benchmark " + run.benchmark);
        int terminated = 0;
        int finished = 0;
        int running = 0;
        for (Object phase : run.phases) {
            if ("TERMINATED".equals(((Phase)phase).status)) {
                ++terminated;
                continue;
            }
            if ("FINISHED".equals(((Phase)phase).status)) {
                ++finished;
                continue;
            }
            if (!"RUNNING".equals(((Phase)phase).status)) continue;
            ++running;
        }
        invocation.print("(phases: " + running + " running, " + finished + " finished, " + terminated + " terminated) [y/N]: ");
        String confirmation = invocation.getShell().readLine();
        switch (confirmation.trim().toLowerCase()) {
            case "y": 
            case "yes": {
                break;
            }
            default: {
                invocation.println("Kill cancelled.");
                return CommandResult.SUCCESS;
            }
        }
        try {
            runRef.kill();
        }
        catch (RestClientException e) {
            invocation.error(e);
            throw new CommandException("Failed to kill run " + run.id, (Throwable)e);
        }
        invocation.println("Killed.");
        return CommandResult.SUCCESS;
    }
}

