/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.ServerCommand;
import io.hyperfoil.cli.commands.ServerOptionCompleter;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClient;
import io.hyperfoil.core.util.Util;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.stream.Stream;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;

@CommandDefinition(name="log", description="Browse remote logs.", aliases={"logs"})
public class Log
extends ServerCommand {
    @Option(name="pager", shortName=112, description="Pager used.")
    private String pager;
    @Argument(description="Node with the log: controller/agent-name", completer=NodeCompleter.class)
    String node;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException, InterruptedException {
        this.ensureConnection(invocation);
        File logFile = invocation.context().getLogFile(this.node);
        String logId = invocation.context().getLogId(this.node);
        long offset = 0L;
        if (logFile == null) {
            try {
                File tmpFile = File.createTempFile((String)(this.node == null ? "hfc." : this.node + "."), ".log");
                tmpFile.deleteOnExit();
                logFile = tmpFile;
            }
            catch (IOException e) {
                invocation.println("Cannot create temporary file for the log: " + Util.explainCauses((Throwable)e));
                return CommandResult.FAILURE;
            }
        }
        try {
            offset = Files.size(logFile.toPath());
        }
        catch (IOException e) {
            invocation.println("Error fetching size of " + logFile + ": " + Util.explainCauses((Throwable)e));
        }
        String newLogId = invocation.context().client().downloadLog(this.node, logId, offset, logFile);
        if (logId == null) {
            invocation.context().addLog(this.node, logFile, newLogId);
        } else if (!logId.equals(newLogId)) {
            invocation.context().updateLogId(this.node, newLogId);
        }
        invocation.context().createPager(this.pager).open(invocation, logFile);
        return CommandResult.SUCCESS;
    }

    public static class NodeCompleter
    extends ServerOptionCompleter {
        public NodeCompleter() {
            super((RestClient client) -> Stream.concat(Stream.of("controller"), client.agents().stream()));
        }
    }
}

