/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.BaseReportCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.controller.Client;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;

@CommandDefinition(name="report", description="Generate HTML report")
public class Report
extends BaseReportCommand {
    @Option(shortName=100, description="Destination path to the HTML report", required=true, askIfNotSet=true)
    private String destination;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        String report = this.getReport(invocation);
        Client.RunRef runRef = this.getRunRef(invocation);
        File destination = new File(this.destination);
        if (destination.exists()) {
            if (destination.isFile()) {
                if (!this.askForOverwrite(invocation, destination)) {
                    invocation.println("Cancelled. You can change destination file with '-d /path/to/report.html'");
                    return CommandResult.SUCCESS;
                }
            } else if (destination.isDirectory() && (destination = destination.toPath().resolve(runRef.id() + ".html").toFile()).exists()) {
                if (destination.isFile()) {
                    if (!this.askForOverwrite(invocation, destination)) {
                        invocation.println("Cancelled. You can change destination file with '-d /path/to/report.html'");
                        return CommandResult.SUCCESS;
                    }
                } else if (destination.isDirectory()) {
                    invocation.println("Both " + this.destination + " and " + destination + " are directories. Please use another path.");
                    return CommandResult.SUCCESS;
                }
            }
        }
        try {
            Files.write(destination.toPath(), report.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new CommandException("Cannot write to '" + destination.toString() + "': ", (Throwable)e);
        }
        invocation.println("Written to " + destination);
        if (!"true".equalsIgnoreCase(System.getenv("HYPERFOIL_CONTAINER"))) {
            this.openInBrowser("file://" + destination.toString());
        }
        return CommandResult.SUCCESS;
    }

    private boolean askForOverwrite(HyperfoilCommandInvocation invocation, File destination) {
        invocation.print("File " + destination + " already exists, overwrite? [y/N]: ");
        boolean overwrite = false;
        try {
            String confirmation = invocation.getShell().readLine();
            switch (confirmation.trim().toLowerCase()) {
                case "y": 
                case "yes": {
                    overwrite = true;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return overwrite;
    }
}

