/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.BenchmarkCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;

@CommandDefinition(name="run", description="Starts benchmark on Hyperfoil Controller server")
public class Run
extends BenchmarkCommand {
    @Option(shortName=100, description="Run description")
    String description;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        Client.BenchmarkRef benchmarkRef = this.ensureBenchmark(invocation);
        try {
            invocation.context().setServerRun(benchmarkRef.start(this.description));
            invocation.println("Started run " + invocation.context().serverRun().id());
        }
        catch (RestClientException e) {
            invocation.error(e);
            throw new CommandException("Failed to start benchmark " + benchmarkRef.name(), (Throwable)e);
        }
        try {
            invocation.executeCommand("status");
        }
        catch (Exception e) {
            invocation.error(e);
            throw new CommandException((Throwable)e);
        }
        return CommandResult.SUCCESS;
    }
}

