/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.Table;
import io.hyperfoil.cli.commands.BaseRunIdCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import io.hyperfoil.controller.model.Run;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;

@CommandDefinition(name="sessions", description="Show sessions statistics")
public class Sessions
extends BaseRunIdCommand {
    Table<Map.Entry<String, Client.MinMax>> SESSION_STATS = new Table<Map.Entry>().column("AGENT", Map.Entry::getKey).column("MIN", e -> String.valueOf(((Client.MinMax)e.getValue()).min), Table.Align.RIGHT).column("MAX", e -> String.valueOf(((Client.MinMax)e.getValue()).max), Table.Align.RIGHT);

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        Client.RunRef runRef = this.getRunRef(invocation);
        Map sessionStats = null;
        try {
            do {
                int numLines = sessionStats == null ? 0 : sessionStats.values().stream().mapToInt(Map::size).sum() + 2;
                sessionStats = runRef.sessionStatsRecent();
                this.clearLines(invocation, numLines);
                if (sessionStats == null || sessionStats.isEmpty()) {
                    Run run = runRef.get();
                    if (run.terminated != null) {
                        invocation.println("Run " + run.id + " has terminated.");
                        invocation.print(this.SESSION_STATS.print("PHASE", this.toMapOfStreams(runRef.sessionStatsTotal())));
                        return CommandResult.SUCCESS;
                    }
                }
                invocation.print(this.SESSION_STATS.print("PHASE", this.toMapOfStreams(sessionStats)));
            } while (!this.interruptibleDelay(invocation));
            return CommandResult.SUCCESS;
        }
        catch (RestClientException e) {
            if (e.getCause() instanceof InterruptedException) {
                this.clearLines(invocation, 1);
                invocation.println("");
                return CommandResult.SUCCESS;
            }
            invocation.error(e);
            throw new CommandException("Cannot display session stats.", (Throwable)e);
        }
    }

    private Map<String, Stream<Map.Entry<String, Client.MinMax>>> toMapOfStreams(Map<String, Map<String, Client.MinMax>> sessionStats) {
        return sessionStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Sessions::soretdEntries, Sessions.throwingMerger(), TreeMap::new));
    }

    private static Stream<Map.Entry<String, Client.MinMax>> soretdEntries(Map.Entry<String, Map<String, Client.MinMax>> e) {
        return e.getValue().entrySet().stream().sorted(Map.Entry.comparingByKey());
    }

    private static BinaryOperator<Stream<Map.Entry<String, Client.MinMax>>> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException();
        };
    }
}

