/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.Table;
import io.hyperfoil.cli.commands.BaseRunIdCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import io.hyperfoil.controller.model.CustomStats;
import io.hyperfoil.controller.model.RequestStatisticsResponse;
import io.hyperfoil.controller.model.RequestStats;
import java.util.Collection;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;

@CommandDefinition(name="stats", description="Show run statistics")
public class Stats
extends BaseRunIdCommand {
    private static final Table<RequestStats> REQUEST_STATS_TABLE = new Table<RequestStats>().rowPrefix(r -> r.failedSLAs.isEmpty() ? null : "\u001b[0;31m").rowSuffix(r -> "\u001b[0m").column("PHASE", r -> r.phase).column("METRIC", r -> r.metric).column("THROUGHPUT", Stats::throughput, Table.Align.RIGHT).columnInt("REQUESTS", r -> r.summary.requestCount).columnNanos("MEAN", r -> r.summary.meanResponseTime).columnNanos("p50", r -> (Long)r.summary.percentileResponseTime.get(50.0)).columnNanos("p90", r -> (Long)r.summary.percentileResponseTime.get(90.0)).columnNanos("p99", r -> (Long)r.summary.percentileResponseTime.get(99.0)).columnNanos("p99.9", r -> (Long)r.summary.percentileResponseTime.get(99.9)).columnNanos("p99.99", r -> (Long)r.summary.percentileResponseTime.get(99.99)).columnInt("2xx", r -> r.summary.status_2xx).columnInt("3xx", r -> r.summary.status_3xx).columnInt("4xx", r -> r.summary.status_4xx).columnInt("5xx", r -> r.summary.status_5xx).columnInt("CACHE", r -> r.summary.cacheHits).columnInt("TIMEOUTS", r -> r.summary.timeouts).columnInt("ERRORS", r -> r.summary.resetCount + r.summary.connectFailureCount + r.summary.status_other + r.summary.internalErrors).columnNanos("BLOCKED", r -> r.summary.blockedTime);
    private static final Table<CustomStats> CUSTOM_STATS_TABLE = new Table<CustomStats>().column("PHASE", c -> c.phase).columnInt("STEP", c -> c.stepId).column("METRIC", c -> c.metric).column("NAME", c -> c.customName).column("VALUE", c -> c.value);
    @Option(name="total", shortName=116, description="Show total stats instead of recent.", hasValue=false)
    private boolean total;
    @Option(name="custom", shortName=99, description="Show custom stats (total only)", hasValue=false)
    private boolean custom;

    private static String throughput(RequestStats r) {
        if (r.summary.endTime <= r.summary.startTime) {
            return "<none>";
        }
        double rate = 1000.0 * (double)r.summary.responseCount / (double)(r.summary.endTime - r.summary.startTime);
        if (rate < 10000.0) {
            return String.format("%.2f req/s", rate);
        }
        if (rate < 1.0E7) {
            return String.format("%.2fk req/s", rate / 1000.0);
        }
        return String.format("%.2fM req/s", rate / 1000000.0);
    }

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        Client.RunRef runRef = this.getRunRef(invocation);
        if (this.custom) {
            this.showCustomStats(invocation, runRef);
        } else {
            this.showStats(invocation, runRef);
        }
        return CommandResult.SUCCESS;
    }

    private void showStats(HyperfoilCommandInvocation invocation, Client.RunRef runRef) throws CommandException {
        boolean terminated = false;
        int prevLines = -2;
        do {
            RequestStatisticsResponse stats;
            try {
                stats = this.total || terminated ? runRef.statsTotal() : runRef.statsRecent();
            }
            catch (RestClientException e) {
                if (e.getCause() instanceof InterruptedException) {
                    this.clearLines(invocation, 1);
                    invocation.println("");
                    return;
                }
                invocation.error(e);
                throw new CommandException("Cannot fetch stats for run " + runRef.id(), (Throwable)e);
            }
            if ("TERMINATED".equals(stats.status)) {
                stats = runRef.statsTotal();
                terminated = true;
            }
            this.clearLines(invocation, prevLines + 2);
            if (this.total || terminated) {
                invocation.println("Total stats from run " + runRef.id());
            } else {
                invocation.println("Recent stats from run " + runRef.id());
            }
            invocation.println(REQUEST_STATS_TABLE.print(stats.statistics.stream()));
            prevLines = stats.statistics.size() + 2;
            for (RequestStats rs : stats.statistics) {
                for (String msg : rs.failedSLAs) {
                    invocation.println(String.format("%s/%s: %s", rs.phase, rs.metric == null ? "*" : rs.metric, msg));
                    ++prevLines;
                }
            }
        } while (!terminated && !this.interruptibleDelay(invocation));
    }

    private void showCustomStats(HyperfoilCommandInvocation invocation, Client.RunRef runRef) throws CommandException {
        try {
            Collection customStats = runRef.customStats();
            invocation.println(CUSTOM_STATS_TABLE.print(customStats.stream()));
        }
        catch (RestClientException e) {
            invocation.error(e);
            throw new CommandException("Cannot fetch custom stats for run " + runRef.id(), (Throwable)e);
        }
    }

    private int numLines(String string) {
        int lines = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            ++lines;
        }
        return lines;
    }
}

