/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.Table;
import io.hyperfoil.cli.commands.BaseRunIdCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import io.hyperfoil.controller.model.Phase;
import io.hyperfoil.controller.model.Run;
import java.text.SimpleDateFormat;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;

@CommandDefinition(name="status", description="Prints information about executing or completed run.")
public class Status
extends BaseRunIdCommand {
    private static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private static final Table<Phase> PHASE_TABLE = new Table<Phase>().column("NAME", p -> p.name).column("STATUS", p -> p.status).column("STARTED", p -> p.started == null ? null : TIME_FORMATTER.format(p.started)).column("REMAINING", p -> p.remaining, Table.Align.RIGHT).column("COMPLETED", p -> p.completed == null ? null : TIME_FORMATTER.format(p.completed)).column("TOTAL DURATION", p -> p.totalDuration).column("DESCRIPTION", p -> p.description);
    @Option(name="all", shortName=97, description="Show all phases", hasValue=false)
    boolean all;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        Run run;
        Client.RunRef runRef = this.getRunRef(invocation);
        try {
            run = runRef.get();
        }
        catch (RestClientException e) {
            invocation.error(e);
            throw new CommandException("Cannot fetch status for run " + runRef.id(), (Throwable)e);
        }
        invocation.println("Run " + run.id + ", benchmark " + run.benchmark);
        if (run.description != null) {
            invocation.println(run.description);
        }
        while (true) {
            if (run.agents != null && !run.agents.isEmpty()) {
                invocation.print("Agents: ");
                invocation.println(String.join((CharSequence)", ", (CharSequence[])run.agents.stream().map(a -> a.name + "[" + a.status + "]").toArray(String[]::new)));
            }
            if (run.started != null) {
                invocation.print("Started: " + DATE_FORMATTER.format(run.started) + "    ");
            }
            if (run.terminated != null) {
                invocation.println("Terminated: " + DATE_FORMATTER.format(run.terminated));
            } else {
                invocation.println("");
            }
            Run r = run;
            invocation.print(PHASE_TABLE.print(run.phases.stream().filter(p -> this.showPhase(r, (Phase)p))));
            long cancelled = run.phases.stream().filter(p -> "CANCELLED".equals(p.status)).count();
            if (cancelled > 0L) {
                invocation.println(cancelled + " phases were cancelled.");
            }
            if (!run.errors.isEmpty()) {
                invocation.println("Errors:");
                for (String note : run.errors) {
                    invocation.println(note);
                }
            }
            if (run.terminated != null) {
                return CommandResult.SUCCESS;
            }
            if (this.interruptibleDelay(invocation)) {
                return CommandResult.SUCCESS;
            }
            try {
                run = runRef.get();
            }
            catch (RestClientException e) {
                if (e.getCause() instanceof InterruptedException) {
                    this.clearLines(invocation, 1);
                    invocation.println("");
                    return CommandResult.SUCCESS;
                }
                invocation.error(e);
                throw new CommandException("Cannot fetch status for run " + runRef.id(), (Throwable)e);
            }
            int lines = 4;
            lines += (int)r.phases.stream().filter(p -> this.showPhase(r, (Phase)p)).count();
            lines += cancelled > 0L ? 1 : 0;
            this.clearLines(invocation, lines += run.errors.isEmpty() ? 0 : run.errors.size() + 1);
        }
    }

    private boolean showPhase(Run run, Phase phase) {
        return (this.all || run.terminated != null) && !"CANCELLED".equals(phase.status) || "RUNNING".equals(phase.status) || "FINISHED".equals(phase.status);
    }
}

