/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.cli.CliUtil;
import io.hyperfoil.cli.commands.ServerCommand;
import io.hyperfoil.cli.context.HyperfoilCliContext;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import io.hyperfoil.core.impl.LocalBenchmarkData;
import io.hyperfoil.core.parser.BenchmarkParser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.Collectors;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Argument;
import org.aesh.io.Resource;

@CommandDefinition(name="upload", description="Uploads benchmark definition to Hyperfoil Controller server")
public class Upload
extends ServerCommand {
    @Argument(description="YAML benchmark definition file", required=true)
    Resource benchmarkResource;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        Benchmark benchmark;
        this.ensureConnection(invocation);
        HyperfoilCliContext ctx = invocation.context();
        try {
            Resource sanitizedResource = CliUtil.sanitize(this.benchmarkResource);
            benchmark = BenchmarkParser.instance().buildBenchmark(Util.toString((InputStream)sanitizedResource.read()), (BenchmarkData)new LocalBenchmarkData(Paths.get(sanitizedResource.getAbsolutePath(), new String[0])));
        }
        catch (BenchmarkDefinitionException | ParserException e) {
            invocation.error(e);
            throw new CommandException("Failed to parse the benchmark.", e);
        }
        catch (IOException e) {
            invocation.error(e);
            throw new CommandException("Failed to load the benchmark.", (Throwable)e);
        }
        invocation.println("Loaded benchmark " + benchmark.name() + ", uploading...");
        try {
            Util.serialize((Benchmark)benchmark);
        }
        catch (IOException e) {
            invocation.error("Failed to serialize the benchmark: " + Util.explainCauses((Throwable)e));
        }
        try {
            Path benchmarkDir = Paths.get(this.benchmarkResource.getAbsolutePath(), new String[0]).getParent();
            Map<String, Path> extraFiles = benchmark.files().keySet().stream().collect(Collectors.toMap(file -> file, file -> {
                Path path = Paths.get(file, new String[0]);
                return path.isAbsolute() ? path : benchmarkDir.resolve((String)file);
            }));
            Client.BenchmarkRef benchmarkRef = ctx.client().register(this.benchmarkResource.getAbsolutePath(), extraFiles, null, null);
            ctx.setServerBenchmark(benchmarkRef);
            invocation.println("... done.");
            return CommandResult.SUCCESS;
        }
        catch (RestClientException e) {
            invocation.error(e);
            throw new CommandException("Failed to upload the benchmark.", (Throwable)e);
        }
    }
}

