/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.api.processor.RawBytesHandler;
import io.hyperfoil.api.statistics.StatisticsSummary;
import io.hyperfoil.cli.commands.Exit;
import io.hyperfoil.cli.commands.StartLocal;
import io.hyperfoil.cli.context.HyperfoilCliContext;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.cli.context.HyperfoilCommandInvocationProvider;
import io.hyperfoil.client.RestClient;
import io.hyperfoil.controller.Client;
import io.hyperfoil.controller.HistogramConverter;
import io.hyperfoil.controller.model.CustomStats;
import io.hyperfoil.controller.model.Histogram;
import io.hyperfoil.controller.model.RequestStatisticsResponse;
import io.hyperfoil.controller.model.RequestStats;
import io.hyperfoil.core.handlers.TransferSizeRecorder;
import io.hyperfoil.core.util.Util;
import io.hyperfoil.function.SerializableBiConsumer;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.config.HttpPluginBuilder;
import io.hyperfoil.http.config.Protocol;
import io.hyperfoil.http.steps.HttpStepCatalog;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.HistogramIterationValue;
import org.aesh.command.AeshCommandRuntimeBuilder;
import org.aesh.command.Command;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandResult;
import org.aesh.command.CommandRuntime;
import org.aesh.command.impl.registry.AeshCommandRegistryBuilder;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationProvider;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionGroup;
import org.aesh.command.option.OptionList;
import org.aesh.terminal.utils.ANSI;
import org.aesh.terminal.utils.Config;

public abstract class WrkAbstract {
    protected abstract String getCommand();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mainMethod(String[] args, Class<? extends AbstractWrkCommand> wrkClass) {
        block8: {
            System.setProperty("vertx.logger-delegate-factory-class-name", "io.vertx.core.logging.Log4j2LogDelegateFactory");
            CommandRuntime cr = null;
            try {
                AeshCommandRuntimeBuilder runtime = AeshCommandRuntimeBuilder.builder();
                runtime.commandInvocationProvider((CommandInvocationProvider)new HyperfoilCommandInvocationProvider(new HyperfoilCliContext()));
                AeshCommandRegistryBuilder registry = AeshCommandRegistryBuilder.builder().commands(new Class[]{StartLocal.class, wrkClass, Exit.class});
                runtime.commandRegistry(registry.create());
                cr = runtime.build();
                try {
                    cr.executeCommand("start-local --quiet");
                    cr.executeCommand(this.getCommand() + " " + String.join((CharSequence)" ", args));
                }
                finally {
                    cr.executeCommand("exit");
                }
            }
            catch (Exception e) {
                System.out.println("Failed to execute command: " + e.getMessage());
                if (Boolean.getBoolean("io.hyperfoil.stacktrace")) {
                    e.printStackTrace();
                }
                if (cr == null) break block8;
                try {
                    System.out.println(cr.getCommandRegistry().getCommand(this.getCommand(), this.getCommand()).printHelp(this.getCommand()));
                }
                catch (CommandNotFoundException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
    }

    static {
        Handler[] handlers = Logger.getLogger("").getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            handlers[index].setLevel(Level.SEVERE);
        }
    }

    public abstract class AbstractWrkCommand
    implements Command<HyperfoilCommandInvocation> {
        @Option(shortName=99, description="Total number of HTTP connections to keep open", defaultValue={"10"})
        int connections;
        @Option(shortName=100, description="Duration of the test, e.g. 2s, 2m, 2h", defaultValue={"10s"})
        String duration;
        @Option(shortName=116, description="Total number of threads to use.", defaultValue={"2"})
        int threads;
        @Option(shortName=115, description="!!!NOT SUPPORTED: LuaJIT script")
        String script;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        boolean help;
        @OptionList(shortName=72, name="header", description="HTTP header to add to request, e.g. \"User-Agent: wrk\"")
        List<String> headers;
        @Option(description="Print detailed latency statistics", hasValue=false)
        boolean latency;
        @Option(description="Record a timeout if a response is not received within this amount of time.", defaultValue={"60s"})
        String timeout;
        @OptionGroup(shortName=65, description="Inline definition of agent executing the test. By default assuming non-clustered mode.")
        Map<String, String> agent;
        @Option(description="HTTP2 is not supported in wrk/wrk2: you can enable that for Hyperfoil.", defaultValue={"false"})
        boolean enableHttp2;
        @Argument(description="URL that should be accessed", required=true)
        String url;
        String path;
        String[][] parsedHeaders;

        public CommandResult execute(HyperfoilCommandInvocation invocation) {
            URI uri;
            if (this.help) {
                invocation.println(invocation.getHelpInfo(WrkAbstract.this.getCommand()));
                return CommandResult.SUCCESS;
            }
            if (this.script != null) {
                invocation.println("Scripting is not supported at this moment.");
            }
            if (!this.url.startsWith("http://") && !this.url.startsWith("https://")) {
                this.url = "http://" + this.url;
            }
            try {
                uri = new URI(this.url);
            }
            catch (URISyntaxException e) {
                invocation.println("Failed to parse URL: " + e.getMessage());
                return CommandResult.FAILURE;
            }
            this.path = uri.getPath();
            if (uri.getQuery() != null) {
                this.path = this.path + "?" + uri.getQuery();
            }
            if (uri.getFragment() != null) {
                this.path = this.path + "#" + uri.getFragment();
            }
            if (this.headers != null) {
                this.parsedHeaders = new String[this.headers.size()][];
                for (int i = 0; i < this.headers.size(); ++i) {
                    String h = this.headers.get(i);
                    int colonIndex = h.indexOf(58);
                    if (colonIndex < 0) {
                        invocation.println(String.format("Cannot parse header '%s', ignoring.", h));
                        continue;
                    }
                    String header = h.substring(0, colonIndex).trim();
                    String value = h.substring(colonIndex + 1).trim();
                    this.parsedHeaders[i] = new String[]{header, value};
                }
            } else {
                this.parsedHeaders = null;
            }
            Protocol protocol = Protocol.fromScheme((String)uri.getScheme());
            BenchmarkBuilder builder = ((HttpPluginBuilder)new BenchmarkBuilder(null, BenchmarkData.EMPTY).name(WrkAbstract.this.getCommand()).addPlugin(HttpPluginBuilder::new)).ergonomics().repeatCookies(false).userAgentFromSession(false).endErgonomics().http().protocol(protocol).host(uri.getHost()).port(protocol.portOrDefault(uri.getPort())).allowHttp2(this.enableHttp2).sharedConnections(this.connections).endHttp().endPlugin().threads(this.threads);
            if (this.agent != null) {
                for (Map.Entry<String, String> agent : this.agent.entrySet()) {
                    Map<String, String> properties = Stream.of(agent.getValue().split(",")).map(property -> {
                        String[] pair = property.split("=", 2);
                        if (pair.length != 2) {
                            throw new IllegalArgumentException("Cannot parse " + property + " as a property: Agent should be formatted as -AagentName=key1=value1,key2=value2...");
                        }
                        return pair;
                    }).collect(Collectors.toMap(keyValue -> keyValue[0], keyValue -> keyValue[1]));
                    builder.addAgent(agent.getKey(), null, properties);
                }
            }
            this.addPhase(builder, "calibration", "6s");
            this.addPhase(builder, "test", this.duration).startAfterStrict("calibration").maxDuration(Util.parseToMillis((String)this.duration));
            RestClient client = invocation.context().client();
            if (client == null) {
                invocation.println("You're not connected to a controller; either " + ANSI.BOLD + "connect\u001b[0;22m to running instance or use " + ANSI.BOLD + "start-local\u001b[0;22m to start a controller in this VM");
                return CommandResult.FAILURE;
            }
            Client.BenchmarkRef benchmark = client.register(builder.build(), null);
            invocation.context().setServerBenchmark(benchmark);
            Client.RunRef run = benchmark.start(null);
            invocation.context().setServerRun(run);
            invocation.println("Running for " + this.duration + " test @ " + this.url);
            invocation.println(this.threads + " threads and " + this.connections + " connections");
            while (true) {
                RequestStatisticsResponse recent = run.statsRecent();
                if ("TERMINATED".equals(recent.status)) break;
                invocation.getShell().write(ANSI.CURSOR_START);
                invocation.getShell().write(ANSI.ERASE_WHOLE_LINE);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    invocation.println("Interrupt received, trying to abort run...");
                    run.kill();
                }
            }
            invocation.println(Config.getLineSeparator() + "benchmark finished");
            RequestStatisticsResponse total = run.statsTotal();
            Collection custom = run.customStats().stream().filter(cs -> cs.phase.equals("test")).collect(Collectors.toList());
            RequestStats testStats = total.statistics.stream().filter(rs -> "test".equals(rs.phase)).findFirst().orElseThrow(() -> new IllegalStateException("Missing stats for phase 'test'"));
            AbstractHistogram histogram = HistogramConverter.convert((Histogram)run.histogram(testStats.phase, testStats.stepId, testStats.metric));
            this.printStats(testStats.summary, histogram, custom, invocation);
            return CommandResult.SUCCESS;
        }

        protected abstract PhaseBuilder<?> phaseConfig(PhaseBuilder.Catalog var1);

        private PhaseBuilder<?> addPhase(BenchmarkBuilder benchmarkBuilder, String phase, String durationStr) {
            String[][] parsedHeaders = this.parsedHeaders;
            long duration = Util.parseToMillis((String)durationStr);
            return ((HttpStepCatalog)this.phaseConfig(benchmarkBuilder.addPhase(phase)).duration(duration).maxDuration(duration + Util.parseToMillis((String)this.timeout)).scenario().initialSequence("request").step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path(this.path).headerAppender((SerializableBiConsumer & Serializable)(session, request) -> {
                if (parsedHeaders != null) {
                    for (String[] header : parsedHeaders) {
                        request.putHeader((CharSequence)header[0], (CharSequence)header[1]);
                    }
                }
            }).timeout(this.timeout).handler().rawBytes((RawBytesHandler)new TransferSizeRecorder("sent", "received")).endHandler().endStep().endSequence().endScenario();
        }

        private void printStats(StatisticsSummary stats, AbstractHistogram histogram, Collection<CustomStats> custom, CommandInvocation<?> invocation) {
            long dataSent = custom.stream().filter(cs -> cs.customName.equals("sent")).mapToLong(cs -> Long.parseLong(cs.value)).findFirst().orElse(0L);
            long dataReceived = custom.stream().filter(cs -> cs.customName.equals("received")).mapToLong(cs -> Long.parseLong(cs.value)).findFirst().orElse(0L);
            double durationSeconds = (double)(stats.endTime - stats.startTime) / 1000.0;
            invocation.println("                  Avg     Stdev       Max");
            invocation.println("Latency:    " + Util.prettyPrintNanosFixed((long)stats.meanResponseTime) + " " + Util.prettyPrintNanosFixed((long)((long)histogram.getStdDeviation())) + " " + Util.prettyPrintNanosFixed((long)stats.maxResponseTime));
            if (this.latency) {
                invocation.println("Latency Distribution");
                for (Map.Entry entry : stats.percentileResponseTime.entrySet()) {
                    invocation.println(String.format("%7.3f", entry.getKey()) + " " + Util.prettyPrintNanosFixed((long)((Long)entry.getValue())));
                }
                invocation.println("----------------------------------------------------------");
                invocation.println("Detailed Percentile Spectrum");
                invocation.println("    Value  Percentile  TotalCount  1/(1-Percentile)");
                for (HistogramIterationValue value : histogram.percentiles(5)) {
                    invocation.println(Util.prettyPrintNanosFixed((long)value.getValueIteratedTo()) + " " + String.format("%9.5f%%  %10d  %15.2f", value.getPercentile(), value.getTotalCountToThisValue(), 100.0 / (100.0 - value.getPercentile())));
                }
                invocation.println("----------------------------------------------------------");
            }
            invocation.println(stats.requestCount + " requests in " + durationSeconds + "s, " + Util.prettyPrintData((double)(dataSent + dataReceived)) + " read");
            invocation.println("Requests/sec: " + String.format("%.02f", (double)stats.requestCount / durationSeconds));
            if (stats.connectFailureCount + stats.resetCount + stats.timeouts + stats.internalErrors + stats.status_4xx + stats.status_5xx > 0) {
                invocation.println("Socket errors: connect " + stats.connectFailureCount + ", reset " + stats.resetCount + ", timeout " + stats.timeouts);
                invocation.println("Non-2xx or 3xx responses: " + stats.status_4xx + stats.status_5xx + stats.status_other);
            }
            invocation.println("Transfer/sec: " + Util.prettyPrintData((double)((double)(dataSent + dataReceived) / durationSeconds)));
        }
    }
}

