/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.context;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.cli.Pager;
import io.hyperfoil.cli.ProcessPager;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClient;
import io.hyperfoil.controller.Client;
import io.vertx.core.Vertx;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.aesh.command.CommandException;
import org.aesh.command.registry.CommandRegistry;

public class HyperfoilCliContext {
    private final Vertx vertx;
    private final boolean providedVertx;
    private Benchmark benchmark;
    private RestClient client;
    private Client.BenchmarkRef serverBenchmark;
    private Client.RunRef serverRun;
    private Map<String, File> logFiles = new HashMap<String, File>();
    private Map<String, String> logIds = new HashMap<String, String>();
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "CLI-scheduled-executor");
        thread.setDaemon(true);
        return thread;
    });
    private String controllerId;
    private ScheduledFuture<?> controllerPollTask;
    private String localControllerHost = null;
    private int localControllerPort = -1;
    private List<Runnable> cleanup = new ArrayList<Runnable>();
    private boolean online = true;
    private CommandRegistry<HyperfoilCommandInvocation> commandRegistry;
    private List<String> suggestedControllerHosts = Collections.emptyList();

    public HyperfoilCliContext() {
        this(Vertx.vertx(), false);
    }

    protected HyperfoilCliContext(Vertx vertx, boolean providedVertx) {
        this.vertx = vertx;
        this.providedVertx = providedVertx;
    }

    public Benchmark benchmark() {
        return this.benchmark;
    }

    public void setBenchmark(Benchmark benchmark) {
        this.benchmark = benchmark;
    }

    public RestClient client() {
        return this.client;
    }

    public void setClient(RestClient client) {
        this.client = client;
    }

    public void setServerBenchmark(Client.BenchmarkRef ref) {
        this.serverBenchmark = ref;
    }

    public Client.BenchmarkRef serverBenchmark() {
        return this.serverBenchmark;
    }

    public void setServerRun(Client.RunRef ref) {
        this.serverRun = ref;
    }

    public Client.RunRef serverRun() {
        return this.serverRun;
    }

    public File getLogFile(String node) {
        return this.logFiles.get(node);
    }

    public String getLogId(String node) {
        return this.logIds.get(node);
    }

    public void addLog(String node, File file, String id) throws CommandException {
        if (this.logFiles.containsKey(node) || this.logIds.containsKey(node)) {
            throw new CommandException("Log file for " + node + " already present");
        }
        this.logFiles.put(node, file);
        this.logIds.put(node, id);
    }

    public void updateLogId(String node, String logId) {
        this.logIds.put(node, logId);
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    public String controllerId() {
        return this.controllerId;
    }

    public void setControllerId(String id) {
        this.controllerId = id;
    }

    public void setControllerPollTask(ScheduledFuture<?> future) {
        if (this.controllerPollTask != null) {
            this.controllerPollTask.cancel(false);
        }
        this.controllerPollTask = future;
    }

    public String localControllerHost() {
        return this.localControllerHost;
    }

    public void setLocalControllerHost(String localControllerHost) {
        this.localControllerHost = localControllerHost;
    }

    public int localControllerPort() {
        return this.localControllerPort;
    }

    public void setLocalControllerPort(int localControllerPort) {
        this.localControllerPort = localControllerPort;
    }

    public void addCleanup(Runnable runnable) {
        this.cleanup.add(runnable);
    }

    public void stop() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        for (Runnable c : this.cleanup) {
            c.run();
        }
        if (!this.providedVertx) {
            this.vertx.close();
        }
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public boolean online() {
        return this.online;
    }

    public void commandRegistry(CommandRegistry<HyperfoilCommandInvocation> commandRegistry) {
        this.commandRegistry = commandRegistry;
    }

    public CommandRegistry<HyperfoilCommandInvocation> commandRegistry() {
        return this.commandRegistry;
    }

    public Vertx vertx() {
        return this.vertx;
    }

    public synchronized List<String> suggestedControllerHosts() {
        return this.suggestedControllerHosts;
    }

    public synchronized void setSuggestedControllerHosts(List<String> suggestedControllerHosts) {
        this.suggestedControllerHosts = suggestedControllerHosts;
    }

    public String interruptKey() {
        return "Ctrl+C";
    }

    public Pager createPager(String pager) {
        return new ProcessPager(pager);
    }
}

