/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.client;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.client.RestClient;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.client.RunRefImpl;
import io.hyperfoil.controller.Client;
import io.hyperfoil.core.util.Util;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.client.HttpResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

class BenchmarkRefImpl
implements Client.BenchmarkRef {
    private final RestClient client;
    private final String name;

    public BenchmarkRefImpl(RestClient client, String name) {
        this.client = client;
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public Client.BenchmarkSource source() {
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, "/benchmark/" + this.encode(this.name)).putHeader(HttpHeaders.ACCEPT.toString(), "text/vnd.yaml").send(handler), 0, response -> {
            if (response.statusCode() == 200) {
                return new Client.BenchmarkSource(response.bodyAsString(), response.getHeader(HttpHeaders.ETAG.toString()));
            }
            if (response.statusCode() == 406) {
                return null;
            }
            throw RestClient.unexpected((HttpResponse<Buffer>)response);
        });
    }

    public Benchmark get() {
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, "/benchmark/" + this.encode(this.name)).putHeader(HttpHeaders.ACCEPT.toString(), "application/java-serialized-object").send(handler), 200, response -> {
            try {
                return Util.deserialize((byte[])response.bodyAsBuffer().getBytes());
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CompletionException(e);
            }
        });
    }

    public Client.RunRef start(String description) {
        CompletableFuture future = new CompletableFuture();
        this.client.vertx.runOnContext(ctx -> {
            String query = "/benchmark/" + this.encode(this.name) + "/start";
            if (description != null) {
                try {
                    query = query + "?desc=" + URLEncoder.encode(description, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            this.client.request(HttpMethod.GET, query).send(rsp -> {
                if (rsp.succeeded()) {
                    HttpResponse response = (HttpResponse)rsp.result();
                    String location = response.getHeader(HttpHeaders.LOCATION.toString());
                    if (response.statusCode() == 202) {
                        if (location == null) {
                            future.completeExceptionally(new RestClientException("Server did not respond with run location!"));
                        }
                        future.complete(new RunRefImpl(this.client, location));
                    } else if (response.statusCode() == 301) {
                        URL url;
                        if (location == null) {
                            future.completeExceptionally(new RestClientException("Server did not respond with run location!"));
                        }
                        try {
                            url = new URL(location);
                        }
                        catch (MalformedURLException e) {
                            future.completeExceptionally(new RestClientException("Cannot parse URL " + location, new RestClientException(e)));
                            return;
                        }
                        String runId = response.getHeader("x-run-id");
                        this.client.request(HttpMethod.GET, url.getPort(), url.getHost(), url.getFile()).send(rsp2 -> {
                            if (rsp2.succeeded()) {
                                HttpResponse response2 = (HttpResponse)rsp2.result();
                                if (response2.statusCode() >= 200 && response2.statusCode() < 300) {
                                    future.complete(new RunRefImpl(this.client, runId == null ? "last" : runId));
                                } else {
                                    future.completeExceptionally(new RestClientException("Failed to indirectly trigger job on " + location + ", status is " + response2.statusCode()));
                                }
                            } else {
                                future.completeExceptionally(new RestClientException("Failed to indirectly trigger job on " + location, rsp2.cause()));
                            }
                        });
                    } else {
                        future.completeExceptionally(RestClient.unexpected((HttpResponse<Buffer>)response));
                    }
                } else {
                    future.completeExceptionally(rsp.cause());
                }
            });
        });
        return (Client.RunRef)RestClient.waitFor(future);
    }

    public String structure() {
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, "/benchmark/" + this.encode(this.name) + "/structure").putHeader(HttpHeaders.ACCEPT.toString(), "text/vnd.yaml").send(handler), 200, HttpResponse::bodyAsString);
    }

    private String encode(String name) {
        try {
            return URLEncoder.encode(name, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return name;
        }
    }
}

