/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.client;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.client.BenchmarkRefImpl;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.client.RunRefImpl;
import io.hyperfoil.controller.Client;
import io.hyperfoil.controller.model.Run;
import io.hyperfoil.controller.model.Version;
import io.hyperfoil.core.util.Util;
import io.hyperfoil.internal.Properties;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.Json;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.multipart.MultipartForm;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;

public class RestClient
implements Client,
Closeable {
    private static final long REQUEST_TIMEOUT = Properties.getLong((String)"io.hyperfoil.cli.request.timeout", (long)30000L);
    final Vertx vertx;
    final WebClientOptions options;
    private final WebClient client;
    private String authorization;

    public RestClient(Vertx vertx, String host, int port, boolean ssl, boolean insecure, String password) {
        this.vertx = vertx;
        this.options = new WebClientOptions().setDefaultHost(host).setDefaultPort(port);
        if (ssl) {
            this.options.setSsl(true).setUseAlpn(true);
        }
        if (insecure) {
            this.options.setTrustAll(true).setVerifyHost(false);
        }
        this.client = WebClient.create((Vertx)this.vertx, (WebClientOptions)this.options.setFollowRedirects(false));
        this.setPassword(password);
    }

    public void setPassword(String password) {
        this.authorization = password != null ? "Basic " + Base64.getEncoder().encodeToString(("hyperfoil:" + password).getBytes(StandardCharsets.UTF_8)) : null;
    }

    public void setToken(String token) {
        this.authorization = token != null ? "Bearer " + token : null;
    }

    static RestClientException unexpected(HttpResponse<Buffer> response) {
        StringBuilder sb = new StringBuilder("Server responded with unexpected code: ");
        sb.append(response.statusCode()).append(", ").append(response.statusMessage());
        String body = response.bodyAsString();
        if (body != null && !body.isEmpty()) {
            sb.append(":\n").append(body);
        }
        return new RestClientException(sb.toString());
    }

    public String host() {
        return this.options.getDefaultHost();
    }

    public int port() {
        return this.options.getDefaultPort();
    }

    HttpRequest<Buffer> request(HttpMethod method, String path) {
        HttpRequest request = this.client.request(method, path);
        if (this.authorization != null) {
            request.putHeader(HttpHeaders.AUTHORIZATION.toString(), this.authorization);
        }
        return request;
    }

    HttpRequest<Buffer> request(HttpMethod method, int port, String host, String path) {
        return this.client.request(method, (SocketAddress)new SocketAddressImpl(port, host), path);
    }

    public Client.BenchmarkRef register(Benchmark benchmark, String prevVersion) {
        byte[] bytes;
        try {
            bytes = Util.serialize((Benchmark)benchmark);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.sync(handler -> {
            HttpRequest<Buffer> request = this.request(HttpMethod.POST, "/benchmark");
            if (prevVersion != null) {
                request.putHeader(HttpHeaders.IF_MATCH.toString(), prevVersion);
            }
            request.putHeader(HttpHeaders.CONTENT_TYPE.toString(), "application/java-serialized-object").sendBuffer(Buffer.buffer((byte[])bytes), handler);
        }, 0, response -> {
            if (response.statusCode() == 204) {
                return new BenchmarkRefImpl(this, benchmark.name());
            }
            if (response.statusCode() == 409) {
                throw new Client.EditConflictException();
            }
            throw RestClient.unexpected((HttpResponse<Buffer>)response);
        });
    }

    public Client.BenchmarkRef register(String benchmarkFile, Map<String, Path> otherFiles, String prevVersion, String storedFilesBenchmark) {
        return this.sync(handler -> {
            MultipartForm multipart = MultipartForm.create().textFileUpload("benchmark", "benchmark.yaml", benchmarkFile, "text/vnd.yaml");
            for (Map.Entry entry : otherFiles.entrySet()) {
                multipart.binaryFileUpload((String)entry.getKey(), (String)entry.getKey(), ((Path)entry.getValue()).toString(), "application/octet-stream");
            }
            HttpRequest<Buffer> request = this.request(HttpMethod.POST, "/benchmark");
            if (storedFilesBenchmark != null) {
                request.addQueryParam("storedFilesBenchmark", storedFilesBenchmark);
            }
            if (prevVersion != null) {
                request.putHeader(HttpHeaders.IF_MATCH.toString(), prevVersion);
            }
            request.sendMultipartForm(multipart, handler);
        }, 0, response -> {
            if (response.statusCode() == 204) {
                String location = response.getHeader(HttpHeaders.LOCATION.toString());
                if (location == null) {
                    throw new RestClientException("Expected location header.");
                }
                int lastSlash = location.lastIndexOf(47);
                return new BenchmarkRefImpl(this, location.substring(lastSlash + 1));
            }
            if (response.statusCode() == 409) {
                throw new Client.EditConflictException();
            }
            throw RestClient.unexpected((HttpResponse<Buffer>)response);
        });
    }

    public List<String> benchmarks() {
        return this.sync(handler -> this.request(HttpMethod.GET, "/benchmark").send(handler), 200, response -> Arrays.asList((String[])Json.decodeValue((Buffer)((Buffer)response.body()), String[].class)));
    }

    public Client.BenchmarkRef benchmark(String name) {
        return new BenchmarkRefImpl(this, name);
    }

    public List<Run> runs(boolean details) {
        return this.sync(handler -> this.request(HttpMethod.GET, "/run?details=" + details).send(handler), 200, response -> Arrays.asList((Run[])Json.decodeValue((Buffer)((Buffer)response.body()), Run[].class)));
    }

    public Client.RunRef run(String id) {
        return new RunRefImpl(this, id);
    }

    public long ping() {
        return this.sync(handler -> this.request(HttpMethod.GET, "/").send(handler), 200, response -> {
            try {
                String header = response.getHeader("x-epoch-millis");
                return header != null ? Long.parseLong(header) : 0L;
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        });
    }

    public Version version() {
        return this.sync(handler -> this.request(HttpMethod.GET, "/version").send(handler), 0, response -> {
            if (response.statusCode() == 401) {
                throw new Unauthorized();
            }
            if (response.statusCode() == 403) {
                throw new Forbidden();
            }
            if (response.statusCode() >= 300 && response.statusCode() <= 399) {
                String location = response.getHeader(HttpHeaders.LOCATION.toString());
                if (location == null) {
                    throw new RestClientException("Servers suggests redirection but does not include the Location header");
                }
                int pathIndex = location.indexOf(47, 8);
                if (pathIndex >= 0) {
                    location = location.substring(0, pathIndex);
                }
                throw new RedirectToHost(location);
            }
            if (response.statusCode() != 200) {
                throw RestClient.unexpected((HttpResponse<Buffer>)response);
            }
            return (Version)Json.decodeValue((Buffer)((Buffer)response.body()), Version.class);
        });
    }

    public Collection<String> agents() {
        return this.sync(handler -> this.request(HttpMethod.GET, "/agents").send(handler), 200, response -> Arrays.asList((String[])Json.decodeValue((Buffer)((Buffer)response.body()), String[].class)));
    }

    public String downloadLog(String node, String logId, long offset, File destinationFile) {
        String url = "/log" + (String)(node == null ? "" : "/" + node);
        CompletableFuture future = new CompletableFuture();
        this.vertx.runOnContext(ctx -> {
            HttpRequest<Buffer> request = this.request(HttpMethod.GET, url + "?offset=" + offset);
            if (logId != null) {
                request.putHeader(HttpHeaders.IF_MATCH.toString(), logId);
            }
            request.send(rsp -> {
                block17: {
                    if (rsp.failed()) {
                        future.completeExceptionally(rsp.cause());
                        return;
                    }
                    HttpResponse response = (HttpResponse)rsp.result();
                    if (response.statusCode() == 412) {
                        this.downloadFullLog(destinationFile, url, future);
                        return;
                    }
                    if (response.statusCode() != 200) {
                        future.completeExceptionally(RestClient.unexpected((HttpResponse<Buffer>)response));
                        return;
                    }
                    try {
                        String etag = response.getHeader(HttpHeaders.ETAG.toString());
                        if (logId == null) {
                            try {
                                byte[] bytes = response.body() == null ? "<empty log file>".getBytes(StandardCharsets.UTF_8) : ((Buffer)response.body()).getBytes();
                                Files.write(destinationFile.toPath(), bytes, new OpenOption[0]);
                            }
                            catch (IOException e) {
                                throw new RestClientException(e);
                            }
                            future.complete(etag);
                            break block17;
                        }
                        if (etag != null && etag.equals(logId)) {
                            if (response.body() != null) {
                                try (RandomAccessFile rw = new RandomAccessFile(destinationFile, "rw");){
                                    rw.seek(offset);
                                    rw.write(((Buffer)response.body()).getBytes());
                                }
                                catch (IOException e) {
                                    throw new RestClientException(e);
                                }
                            }
                            future.complete(etag);
                            break block17;
                        }
                        this.downloadFullLog(destinationFile, url, future);
                    }
                    catch (Throwable t) {
                        future.completeExceptionally(t);
                    }
                }
            });
        });
        return (String)RestClient.waitFor(future);
    }

    public void shutdown(boolean force) {
        this.sync(handler -> this.request(HttpMethod.GET, "/shutdown?force=" + force).send(handler), 200, response -> null);
    }

    private void downloadFullLog(File destinationFile, String url, CompletableFuture<String> future) {
        this.request(HttpMethod.GET, url).send(rsp -> {
            if (rsp.failed()) {
                future.completeExceptionally(rsp.cause());
                return;
            }
            HttpResponse response = (HttpResponse)rsp.result();
            if (response.statusCode() != 200) {
                future.completeExceptionally(RestClient.unexpected((HttpResponse<Buffer>)response));
                return;
            }
            try {
                Files.write(destinationFile.toPath(), ((Buffer)response.body()).getBytes(), new OpenOption[0]);
                future.complete(response.getHeader(HttpHeaders.ETAG.toString()));
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
    }

    static <T> T waitFor(CompletableFuture<T> future) {
        try {
            return future.get(REQUEST_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RestClientException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RestClientException) {
                throw (RestClientException)e.getCause();
            }
            throw new RestClientException(e.getCause() == null ? e : e.getCause());
        }
        catch (TimeoutException e) {
            throw new RestClientException("Request did not complete within " + REQUEST_TIMEOUT + " ms");
        }
    }

    <T> T sync(Consumer<Handler<AsyncResult<HttpResponse<Buffer>>>> invoker, int statusCode, Function<HttpResponse<Buffer>, T> f) {
        CompletableFuture future = new CompletableFuture();
        this.vertx.runOnContext(ctx -> invoker.accept(rsp -> {
            if (rsp.succeeded()) {
                HttpResponse response = (HttpResponse)rsp.result();
                if (statusCode != 0 && response.statusCode() != statusCode) {
                    future.completeExceptionally(RestClient.unexpected((HttpResponse<Buffer>)response));
                    return;
                }
                try {
                    future.complete(f.apply(response));
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            } else {
                future.completeExceptionally(rsp.cause());
            }
        }));
        return RestClient.waitFor(future);
    }

    @Override
    public void close() {
        this.client.close();
    }

    public String toString() {
        return this.options.getDefaultHost() + ":" + this.options.getDefaultPort();
    }

    public static class RedirectToHost
    extends RestClientException {
        public String host;

        public RedirectToHost(String host) {
            super("Required redirect");
            this.host = host;
        }
    }

    public static class Forbidden
    extends RestClientException {
        public Forbidden() {
            super("Forbidden: password incorrect");
        }
    }

    public static class Unauthorized
    extends RestClientException {
        public Unauthorized() {
            super("Unauthorized: password required");
        }
    }
}

