/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.util.Trie;
import io.hyperfoil.core.util.Util;
import io.hyperfoil.http.HttpUtil;
import io.hyperfoil.http.api.CacheControl;
import io.hyperfoil.http.api.HttpCache;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpRequestWriter;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCacheImpl
implements HttpCache {
    private static final Logger log = LoggerFactory.getLogger(HttpCacheImpl.class);
    private static final Trie REQUEST_CACHE_CONTROL = new Trie("max-age=", "no-cache", "no-store", "max-stale=", "min-fresh=", "only-if-cached");
    private static final Trie RESPONSE_CACHE_CONTROL = new Trie("max-age=", "no-cache", "no-store", "must-revalidate");
    private static final int MAX_AGE = 0;
    private static final int NO_CACHE = 1;
    private static final int NO_STORE = 2;
    private static final int MAX_STALE = 3;
    private static final int MIN_FRESH = 4;
    private static final int ONLY_IF_CACHED = 5;
    private static final int MUST_REVALIDATE = 3;
    private final Clock clock;
    private final Map<CharSequence, Map<CharSequence, List<Record>>> records = new HashMap<CharSequence, Map<CharSequence, List<Record>>>();
    private final List<Record> freeRecords = new ArrayList<Record>();
    private final List<List<Record>> freeLists = new ArrayList<List<Record>>();
    private final Function<CharSequence, List<Record>> newList = this::newList;

    public HttpCacheImpl(Clock clock) {
        this.clock = clock;
    }

    @Override
    public void onSessionReset(Session session) {
        this.clear();
    }

    @Override
    public void beforeRequestHeaders(HttpRequest request) {
        switch (request.method) {
            case GET: 
            case HEAD: {
                break;
            }
            default: {
                return;
            }
        }
        Map<CharSequence, List<Record>> authorityRecords = this.records.get(request.authority);
        if (authorityRecords == null) {
            return;
        }
        List<Record> pathRecords = authorityRecords.get(request.path);
        if (pathRecords == null || pathRecords.isEmpty()) {
            return;
        }
        for (int i = 0; i < pathRecords.size(); ++i) {
            request.cacheControl.matchingCached.add(pathRecords.get(i));
        }
    }

    @Override
    public void requestHeader(HttpRequest request, CharSequence header, CharSequence value) {
        if (request.method != HttpMethod.GET && request.method != HttpMethod.HEAD) {
            return;
        }
        if (HttpHeaderNames.CACHE_CONTROL.contentEqualsIgnoreCase(header)) {
            this.handleRequestCacheControl(request, value);
        } else if (HttpHeaderNames.PRAGMA.contentEqualsIgnoreCase(header)) {
            if (AsciiString.contentEquals((CharSequence)"no-cache", (CharSequence)value)) {
                request.cacheControl.noCache = true;
            }
        } else if (HttpHeaderNames.IF_MATCH.contentEqualsIgnoreCase(header)) {
            this.handleIfMatch(request, value);
        } else if (HttpHeaderNames.IF_NONE_MATCH.contentEqualsIgnoreCase(header)) {
            this.handleIfNoneMatch(request, value);
        }
    }

    private void handleIfNoneMatch(HttpRequest request, CharSequence value) {
        Iterator<HttpCache.Record> iterator = request.cacheControl.matchingCached.iterator();
        block0: while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.etag == null) {
                iterator.remove();
                continue;
            }
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == ' ') continue;
                if (c == '*') continue block0;
                if (c == 'W') {
                    if (++i < value.length() && value.charAt(i) == '/') continue;
                    log.warn("Invalid If-None-Match: {}", (Object)value);
                    return;
                }
                if (c == '\"') {
                    int start = ++i;
                    while (i < value.length() && value.charAt(i) != '\"') {
                        ++i;
                    }
                    int length = i - start;
                    if (length == record.etag.length() && AsciiString.regionMatches((CharSequence)record.etag, (boolean)false, (int)0, (CharSequence)value, (int)start, (int)length)) continue block0;
                    while (++i < value.length() && value.charAt(i) == ' ') {
                    }
                    if (i >= value.length() || value.charAt(i) == ',') continue;
                    log.warn("Invalid If-None-Match: {}", (Object)value);
                    return;
                }
                log.warn("Invalid If-None-Match: {}", (Object)value);
                return;
            }
            iterator.remove();
        }
    }

    private void handleIfMatch(HttpRequest request, CharSequence value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == ' ') continue;
            if (c == '*') {
                request.cacheControl.matchingCached.clear();
                return;
            }
            if (c == '\"') {
                int start = ++i;
                while (i < value.length() && value.charAt(i) != '\"') {
                    ++i;
                }
                int length = i - start;
                List<HttpCache.Record> matchingCached = request.cacheControl.matchingCached;
                Iterator<HttpCache.Record> it = matchingCached.iterator();
                while (it.hasNext()) {
                    HttpCache.Record item = it.next();
                    Record record = (Record)item;
                    if (record.etag == null || record.weakETag || length != record.etag.length() || !AsciiString.regionMatches((CharSequence)record.etag, (boolean)false, (int)0, (CharSequence)value, (int)start, (int)length)) continue;
                    it.remove();
                }
                while (++i < value.length() && value.charAt(i) == ' ') {
                }
                if (i >= value.length() || value.charAt(i) == ',') continue;
                log.warn("Invalid If-Match: {}", (Object)value);
                return;
            }
            log.warn("Invalid If-Match: {}", (Object)value);
            return;
        }
    }

    private void handleRequestCacheControl(HttpRequest request, CharSequence value) {
        int maxAge = 0;
        int maxStale = 0;
        int minFresh = 0;
        Trie.State state = REQUEST_CACHE_CONTROL.newState();
        block8: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == ',') {
                state.reset();
                while (++i < value.length() && (c = value.charAt(i)) == ' ') {
                }
                --i;
                continue;
            }
            int pos = i + 1;
            switch (state.next((byte)(c & 0xFF))) {
                case 0: {
                    i = HttpCacheImpl.skipNumbers(value, pos);
                    maxAge = HttpCacheImpl.parseIntSaturated(value, pos, i);
                    --i;
                    continue block8;
                }
                case 3: {
                    i = HttpCacheImpl.skipNumbers(value, pos);
                    maxStale = HttpCacheImpl.parseIntSaturated(value, pos, i);
                    --i;
                    continue block8;
                }
                case 4: {
                    i = HttpCacheImpl.skipNumbers(value, pos);
                    minFresh = HttpCacheImpl.parseIntSaturated(value, pos, i);
                    --i;
                    continue block8;
                }
                case 1: {
                    request.cacheControl.noCache = true;
                    continue block8;
                }
                case 2: {
                    request.cacheControl.noStore = true;
                    continue block8;
                }
                case 5: {
                    request.cacheControl.onlyIfCached = true;
                }
            }
        }
        long now = this.clock.millis();
        Iterator<HttpCache.Record> it = request.cacheControl.matchingCached.iterator();
        while (it.hasNext()) {
            Record record = (Record)it.next();
            if (maxAge > 0 && now - record.date > (long)(maxAge * 1000)) {
                it.remove();
                continue;
            }
            if (record.mustRevalidate && now >= record.expires || maxStale > 0 && now - record.expires > (long)(maxStale * 1000)) {
                it.remove();
                continue;
            }
            if (minFresh <= 0 || record.expires - now >= (long)(minFresh * 1000)) continue;
            it.remove();
        }
        if (maxAge > 0 || maxStale > 0 || minFresh > 0) {
            request.cacheControl.ignoreExpires = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCached(HttpRequest request, HttpRequestWriter writer) {
        if (!request.cacheControl.ignoreExpires) {
            long now = this.clock.millis();
            Iterator<HttpCache.Record> iterator = request.cacheControl.matchingCached.iterator();
            while (iterator.hasNext()) {
                Record record = (Record)iterator.next();
                if (record.expires == Long.MIN_VALUE || now <= record.expires) continue;
                iterator.remove();
            }
        }
        if (request.cacheControl.matchingCached.isEmpty()) {
            if (request.cacheControl.onlyIfCached) {
                request.enter();
                try {
                    request.handlers().handleStatus(request, 504, "Request was cache-only.");
                }
                finally {
                    request.exit();
                    request.session.proceed();
                }
                request.cacheControl.wasCached = true;
                return true;
            }
            request.cacheControl.wasCached = false;
            return false;
        }
        Record mostRecent = this.findMostRecent(request);
        if (request.cacheControl.noCache || mostRecent.noCache) {
            this.addValidationHeaders(mostRecent, writer);
            request.cacheControl.wasCached = false;
            return false;
        }
        request.cacheControl.wasCached = true;
        return true;
    }

    private Record findMostRecent(HttpRequest request) {
        Record mostRecent = null;
        for (HttpCache.Record r : request.cacheControl.matchingCached) {
            Record record = (Record)r;
            if (mostRecent != null && record.date >= mostRecent.date) continue;
            mostRecent = record;
        }
        return mostRecent;
    }

    private void addValidationHeaders(Record record, HttpRequestWriter writer) {
        if (record.etag != null) {
            writer.putHeader((CharSequence)HttpHeaderNames.IF_NONE_MATCH, record.etag);
        } else if (record.lastModified > Long.MIN_VALUE) {
            writer.putHeader((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE, HttpUtil.formatDate(record.lastModified));
        }
    }

    @Override
    public void tryStore(HttpRequest request) {
        CacheControl cc = request.cacheControl;
        if (cc.noStore) {
            return;
        }
        if (cc.responseDate == Long.MIN_VALUE) {
            cc.responseDate = this.clock.millis() - (long)(cc.responseAge * 1000);
        }
        if (cc.responseMaxAge != 0) {
            cc.responseExpires = cc.responseDate + (long)(cc.responseMaxAge * 1000);
        }
        if (cc.responseExpires != Long.MIN_VALUE && cc.responseExpires < cc.responseDate) {
            return;
        }
        Map authorityRecords = this.records.computeIfAbsent(request.authority, a -> new HashMap());
        List<Record> pathRecords = authorityRecords.computeIfAbsent(request.path, this.newList);
        if (cc.responseEtag != null) {
            boolean weak = false;
            if (AsciiString.regionMatches((CharSequence)cc.responseEtag, (boolean)false, (int)0, (CharSequence)"W/", (int)0, (int)2)) {
                weak = true;
            }
            for (Record record : pathRecords) {
                if (record.etag.length() != cc.responseEtag.length() - (weak ? 4 : 2) || !AsciiString.regionMatches((CharSequence)record.etag, (boolean)false, (int)0, (CharSequence)cc.responseEtag, (int)(weak ? 1 : 3), (int)record.etag.length())) continue;
                record.update(cc);
                return;
            }
            pathRecords.add(this.newRecord().set(cc));
        } else if (cc.responseLastModified != Long.MIN_VALUE) {
            for (Record record : pathRecords) {
                if (record.lastModified <= cc.responseLastModified) continue;
                return;
            }
            Record record = pathRecords.isEmpty() ? this.newRecord().set(cc) : pathRecords.get(0).update(cc);
            pathRecords.clear();
            pathRecords.add(record);
        } else {
            Record record = null;
            Iterator<Record> iterator = pathRecords.iterator();
            while (iterator.hasNext()) {
                record = iterator.next();
                if (record.lastModified != Long.MIN_VALUE || record.etag != null) continue;
                iterator.remove();
            }
            pathRecords.add(record == null ? this.newRecord().set(cc) : record.update(cc));
        }
    }

    private Record newRecord() {
        return this.freeRecords.isEmpty() ? new Record() : this.freeRecords.remove(this.freeRecords.size() - 1);
    }

    private List<Record> newList(CharSequence key) {
        return this.freeLists.isEmpty() ? new ArrayList<Record>() : this.freeLists.remove(this.freeLists.size() - 1);
    }

    @Override
    public void invalidate(CharSequence authority, CharSequence path) {
        if (AsciiString.regionMatches((CharSequence)"http://", (boolean)false, (int)0, (CharSequence)path, (int)0, (int)"http://".length())) {
            if (!HttpUtil.authorityMatchHttp(path, authority)) {
                return;
            }
            path = path.subSequence(HttpUtil.indexOf(path, "http://".length(), '/'), path.length());
        } else if (AsciiString.regionMatches((CharSequence)"https://", (boolean)false, (int)0, (CharSequence)path, (int)0, (int)"https://".length())) {
            if (!HttpUtil.authorityMatchHttps(path, authority)) {
                return;
            }
            path = path.subSequence(HttpUtil.indexOf(path, "https://".length(), '/'), path.length());
        }
        Map<CharSequence, List<Record>> authorityRecords = this.records.get(authority);
        if (authorityRecords == null) {
            return;
        }
        List<Record> pathRecords = authorityRecords.get(path);
        if (pathRecords != null) {
            pathRecords.clear();
        }
    }

    @Override
    public int size() {
        return this.records.values().stream().flatMap(map -> map.values().stream()).mapToInt(List::size).sum();
    }

    private static int parseIntSaturated(CharSequence value, int begin, int end) {
        return (int)Math.min(Util.parseLong(value, begin, end), Integer.MAX_VALUE);
    }

    private static int skipNumbers(CharSequence value, int pos) {
        int i;
        for (i = pos; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return i;
        }
        return i;
    }

    @Override
    public void responseHeader(HttpRequest request, CharSequence header, CharSequence value) {
        if (HttpHeaderNames.CACHE_CONTROL.contentEqualsIgnoreCase(header)) {
            Trie.State state = RESPONSE_CACHE_CONTROL.newState();
            block6: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == ',') {
                    state.reset();
                    do {
                        if (++i < value.length()) continue;
                        return;
                    } while ((c = value.charAt(i)) == ' ');
                    --i;
                    continue;
                }
                int pos = i + 1;
                switch (state.next((byte)(c & 0xFF))) {
                    case 0: {
                        i = HttpCacheImpl.skipNumbers(value, pos);
                        request.cacheControl.responseMaxAge = HttpCacheImpl.parseIntSaturated(value, pos, i);
                        --i;
                        continue block6;
                    }
                    case 1: {
                        request.cacheControl.responseNoCache = true;
                        continue block6;
                    }
                    case 2: {
                        request.cacheControl.noStore = true;
                        continue block6;
                    }
                    case 3: {
                        request.cacheControl.responseMustRevalidate = true;
                    }
                }
            }
        } else if (HttpHeaderNames.EXPIRES.contentEqualsIgnoreCase(header)) {
            request.cacheControl.responseExpires = HttpUtil.parseDate(value);
        } else if (HttpHeaderNames.AGE.contentEqualsIgnoreCase(header)) {
            request.cacheControl.responseAge = HttpCacheImpl.parseIntSaturated(value, 0, value.length());
        } else if (HttpHeaderNames.DATE.contentEqualsIgnoreCase(header)) {
            request.cacheControl.responseDate = HttpUtil.parseDate(value);
        } else if (HttpHeaderNames.LAST_MODIFIED.contentEqualsIgnoreCase(header)) {
            request.cacheControl.responseLastModified = HttpUtil.parseDate(value);
        } else if (HttpHeaderNames.ETAG.contentEqualsIgnoreCase(header)) {
            request.cacheControl.responseEtag = value;
        } else if (HttpHeaderNames.PRAGMA.contentEqualsIgnoreCase(header) && AsciiString.contentEquals((CharSequence)"no-cache", (CharSequence)value)) {
            request.cacheControl.responseNoCache = true;
        }
    }

    @Override
    public void clear() {
        for (Map<CharSequence, List<Record>> authorityRecords : this.records.values()) {
            for (List<Record> pathRecords : authorityRecords.values()) {
                for (Record record : pathRecords) {
                    record.reset();
                    this.freeRecords.add(record);
                }
                pathRecords.clear();
                this.freeLists.add(pathRecords);
            }
            authorityRecords.clear();
        }
    }

    private static class Record
    implements HttpCache.Record {
        long date;
        long expires;
        boolean noCache;
        boolean mustRevalidate;
        long lastModified;
        boolean weakETag;
        CharSequence etag;

        private Record() {
        }

        Record set(CacheControl cc) {
            this.date = cc.responseDate;
            this.expires = cc.responseExpires;
            this.noCache = cc.responseNoCache;
            this.mustRevalidate = cc.responseMustRevalidate;
            this.lastModified = cc.responseLastModified;
            boolean bl = this.weakETag = cc.responseEtag != null && AsciiString.regionMatches((CharSequence)cc.responseEtag, (boolean)false, (int)0, (CharSequence)"W/", (int)0, (int)2);
            this.etag = cc.responseEtag == null ? null : cc.responseEtag.subSequence(this.weakETag ? 3 : 1, cc.responseEtag.length() - 1);
            return this;
        }

        void reset() {
            this.etag = null;
        }

        Record update(CacheControl cc) {
            this.date = Math.max(this.date, cc.responseDate);
            this.expires = Math.max(this.expires, cc.responseExpires);
            this.noCache = this.noCache || cc.responseNoCache;
            this.mustRevalidate = this.mustRevalidate || cc.responseMustRevalidate;
            this.lastModified = Math.max(this.lastModified, cc.responseLastModified);
            return this;
        }
    }
}

